'use strict';

/**
 * Application modules.
 */
var dia = {
    typeRepas: {
        ALL: "Tous",
        PETIT_DEJEUNER: "Petit déjeuner",
        COLLATION_10H: "Collation de 10h",
        MIDI: "Midi",
        COLLATION_16H: "Collation de 16h",
        DINER: "Dîner",
        COLLATION_SOIR: "Collation du soir"
    },
            
    typeAcces: {
        AUCUN: 0,
        PATIENT: 1,
        MEDECIN: 2,
        ADMINISTRTEUR: 3
    },
    video: {
        INSCRIPTION: 0,
        CONFIGURATION: 1,
        DONNEES: 2,
        BOLUS: 3,
        ALIMENT: 4,
        DUREE_ACTION: 5
    },
    glycemie: {
        minGlycemie: 1.1,
        maxGlycemie: 33.3
    },
    hdc: {
        maxHDC: 300
    },
    valeurRech: {
        minValeurRech: 3.7,
        maxValeurRech: 7.0
    },
    doseCorrection: {
        minDoseCorr: 1.1,
        maxDoseCorr: 5.6
    },
    ratioGlycemique: {
        minRatioGly: 5,
        maxRatioGly: 50
    },

    localizedStrings: {},

    servlet: '/diabete/',
    
    debugMode: false,
    debugMsg: '',
    langue: '',
    
    nHdcTotal: 0,
    
    idMonRepas: 0,
    compRepas: [],
    
    //idUtilisateur: 0,
    idPatientSelect: 0,

    //uti: null,
    utiPatient: null,
    
    currentUser: '',
    currentPatient: '',

//    langage: {},
    
    jqm: {},
    aide: {},
    data: {},
//    user: {},
    main: {},
    accueil: {},
    menu: {},
//    debug: {},
//    admin: {},
//    bolus: {},
//    schema: {},
    config: {},
    patient: {},
    partage: {},
//    calcul: {},
//    medecin: {},
//    aliment: {},
//    favoris: {},
//    quantite: {},
//    transfert: {},
//    rechAliment: {},
    inscription: {},
    information: {},
    connexion: {}
};

$(function() {
    $('#idDialogInscription').hide();
    $('#idDialogLogin').hide();
    $('#idDialogMessage').hide();

    $('#idDataPatient').hide();
    $('#idProposerApp').hide();
    $('#idGestionPatient').hide();
    $('#idGestionMedecin').hide();
    $('#idMenuConnecte').hide();
    dia.idPatientSelect=0;

    dia.jqm.setCookie("kmc",0);
    //$(".navbar-nav li a").click(function(event) {
    //    $(".navbar-collapse").collapse('hide');
    //});

    dia.main.init();
    
//    setTimeout(dia.main.news(), 5000);
    
});

dia.main.news = function ( ) {
    $('#idContentNews').hide()
    $("#idNews").modal('show');
        
    setTimeout(dia.main.showNews, 2000);
};
dia.main.showNews = function ( ) {
    $('#idContentNews').fadeIn( 3000 );
};
dia.main.init = function ( ) {
    dia.connexion.init();
      
//    dia.connexion.connexion("","",true);
    
    dia.jqm.loadPage('accueil/accueil.jsp');
    
    // active menu on select
    $(".nav a").on("click", function(){
        $(".nav").find(".active").removeClass("active");
        $(this).parent().addClass("active");
    });
    
    $('.nav a').on('click', function(){
//        $(".btn-navbar").click(); //bootstrap 2.x
        $(".navbar-toggle").click() //bootstrap 3.x by Richard
    });
   
    dia.jqm.ajaxCall(false);
};
dia.main.connexion = function ( ) { 
    if(!$('#loginErrorMsg').hasClass( "hide" )){
        $('#loginErrorMsg').addClass("hide");
    }
    
    $("#idUsername").val(dia.jqm.getCookie("user"));
    
    $('#idDialogLogin').css("visibility", "visible");
    
    var buttons = [];
    buttons['OK'] = dia.localizedStrings.msg_ok;
    buttons['Cancel'] = dia.localizedStrings. msg_annuler;
    
    var buttonArray = {};
    buttonArray[buttons['OK']] = function() {
        dia.connexion.connexion();
    };
    buttonArray[buttons['Cancel']] = function() {
        $(this).dialog('close');
    };
    
    $( "#idDialogLogin" ).dialog({modal: true,
        buttons: buttonArray
//        buttons: { 
//            "Ok": function() { 
//                dia.connexion.connexion();
//            }, 
//            "Annuler": function() { 
//                $( this ).dialog( "close" ); 
//            }
//        }
    });
};
dia.main.inscription = function ( ) {
    $('#idMedecinBloc').hide();
    $('#idDialogInscription').css("visibility", "visible");
    
    var buttons = [];
    buttons['OK'] = dia.localizedStrings.msg_ok;
    buttons['Cancel'] = dia.localizedStrings. msg_annuler;
    
    var buttonArray = {};
    buttonArray[buttons['OK']] = function() {
        dia.inscription.initInscription();
    };
    buttonArray[buttons['Cancel']] = function() {
        $(this).dialog('close');
    };    
    
    $("#idDialogInscription").dialog({modal: true,
        width: 750,
        buttons: buttonArray
//        height: 810,
//        buttons: {
//            "Ok": function() {
//                dia.inscription.initInscription();
//            },
//            "Annuler": function() {
//                $( this ).dialog( "close" );
//            }
//        }
    });
};
dia.main.setLangage = function ( langue ) {
    $.param( language, langue );    
};
dia.main.initPresentation = function ( ) {
    $('#gallery a').lightBox(
        { maxHeight: 200, maxWidth: 200 },
        { fixedNavigation:true }
    );
    $('#slideDocumentation a').lightBox(
        { maxHeight: 200, maxWidth: 200 },
        { fixedNavigation:true }
    );
    $('#slideConnexion a').lightBox();
    $('#slideCalcul a').lightBox();
    $('#slideFavoris a').lightBox();
    $('#slideDonnees a').lightBox();
    $('#slideAction a').lightBox();
    $('#slideInformation a').lightBox();
    
    $('#idImgInscription a').lightBox(
        { maxHeight: 200, maxWidth: 200 },
        { fixedNavigation:true }
    );

//    $("#idSelectVideo").kendoDropDownList({});
    
    dia.aide.video(0);
};