'use strict';
/**
 * JQuery Mobile Module
 */

/*
 *
 */
dia.jqm.getValeurRecherche = function ( object ) {
    var obj = $(object);
    var valeur=obj.val(); 

    var unite = 0;
    var minValeur = parseFloat(dia.valeurRech.minValeurRech);
    var maxValeur = parseFloat(dia.valeurRech.maxValeurRech);

    unite = dia.config.getConfig('u');
    if(!unite) {unite=1;}
    if(unite==2) {
        minValeur = (minValeur * 18).toFixed(2)
        maxValeur = (maxValeur * 18).toFixed(2)
    }
    else if(unite==3) {
        minValeur = ((minValeur * 18)/100).toFixed(2)
        maxValeur = ((maxValeur * 18)/100).toFixed(2)
    }

    if(valeur<minValeur || valeur>maxValeur) {
        dia.jqm.messageBox(dia.localizedStrings.msg_valeurRecherche + minValeur + dia.localizedStrings.msg_A + maxValeur);
    }
}

/*
 * getGlycemie : test si la valeur de la glycémie est entre les seuils
 */
dia.jqm.getGlycemie = function ( object ) {
    var obj = $(object);
    var valGlycemie=obj.val(); 
    
    var unite = 0;
    var minGlycemie = parseFloat(dia.glycemie.minGlycemie);
    var maxGlycemie = parseFloat(dia.glycemie.maxGlycemie);

    unite = dia.config.getConfig('u');
    if(!unite) {unite=1;}
    if(unite==2) {
        minGlycemie = (minGlycemie * 18).toFixed(2)
        maxGlycemie = (maxGlycemie * 18).toFixed(2)
    }
    else if(unite==3) {
        minGlycemie = ((minGlycemie * 18)/100).toFixed(2)
        maxGlycemie = ((maxGlycemie * 18)/100).toFixed(2)
    }

    if(valGlycemie>0){
        if(valGlycemie<minGlycemie || valGlycemie>maxGlycemie){
            dia.jqm.messageBox(dia.localizedStrings.msg_ecartGlycemie + minGlycemie + dia.localizedStrings.msg_Et + maxGlycemie);
        }
    }
}
dia.jqm.getRatioGlycemique = function ( object ) {
    var obj = $(object);
    var id = obj.attr('id');
    var valeur=obj.val(); 
    var unite=0;
    var ratio=0;

    var minValeur = parseFloat(dia.ratioGlycemique.minRatioGly);
    var maxValeur = parseFloat(dia.ratioGlycemique.maxRatioGly);

    if(id=='idHdc1'){
        unite=$('#idUnite1').val();
    }
    else if(id=='idHdc2'){
        unite=$('#idUnite2').val();
    }
    else if(id=='idHdc3'){
        unite=$('#idUnite3').val();
    }
    else if(id=='idHdc4'){
        unite=$('#idUnite4').val();
    }
    else if(id=='idHdc5'){
        unite=$('#idUnite5').val();
    }
    else if(id=='idHdc6'){
        unite=$('#idUnite6').val();
    }
    
    if(unite>0 && valeur>0){
        ratio = (valeur / unite);
        if(ratio<minValeur || ratio>maxValeur) {
            dia.jqm.messageBox(dia.localizedStrings.msg_rationGlycemique + minValeur + dia.localizedStrings.msg_A + maxValeur);
        }
    }
};    
dia.jqm.getDoseCorrection = function ( object ) {
    var obj = $(object);
    var valeur=obj.val(); 
    
    var unite = 0;
    var minValeur = parseFloat(dia.doseCorrection.minDoseCorr);
    var maxValeur = parseFloat(dia.doseCorrection.maxDoseCorr);

    unite = dia.config.getConfig('u');
    if(!unite) {unite=1;}
    if(unite==2) {
        minValeur = (minValeur * 18).toFixed(2)
        maxValeur = (maxValeur * 18).toFixed(2)
    }
    else if(unite==3) {
        minValeur = ((minValeur * 18)/100).toFixed(2)
        maxValeur = ((maxValeur * 18)/100).toFixed(2)
    }
    
    if(valeur<minValeur || valeur>maxValeur) {
        dia.jqm.messageBox(dia.localizedStrings.msg_valeurCorrection + minValeur + dia.localizedStrings.msg_A + maxValeur);
    }
};    

dia.jqm.getHdc = function (object) {
    var obj = $(object);
    var nHdc=parseFloat(obj.val()); 
    if(nHdc>dia.hdc.maxHDC) {
        dia.jqm.messageBox(dia.localizedStrings.msg_valeurMaxHDC + dia.hdc.maxHDC);
    }
};
dia.jqm.setCookie = function ( name, value ) {
    return $.cookie( name, value, {expires: 60} );
};
dia.jqm.getCookie = function ( name ) {
    return $.cookie( name );
};
dia.jqm.delCookie = function ( name ) {
    $.removeCookie( name );
//    $.cookie( name, null );
};
dia.jqm.clearData = function ( ) {
    dia.jqm.clearCookies();
    dia.jqm.clearLocalStorage();
}
dia.jqm.clearCookies = function ( ) {
    var cookies = $.cookie();
    for(var cookie in cookies) {
        $.removeCookie(cookie);
    }
};
dia.jqm.dateToString = function( dt ) { 
    var curDt = new Date(dt);
    var dd = curDt.getDate().toString();
    var mm = (1 + curDt.getMonth()).toString();
    var dateStr =  (dd[1]?dd:"0"+dd[0]) + "/" + (mm[1]?mm:"0"+mm[0]) + "/" + curDt.getFullYear().toString();
    return dateStr;
};
dia.jqm.initTypeNumber = function ( ) {
    $("input[type='number']").each(function(i, el) {
        el.type = "text";
        el.onfocus = function(){this.type="number";};
        el.onblur = function(){this.type="text";};
    });
};

dia.jqm.isValidEmailAddress = function ( emailAddress ) {   
    if(emailAddress) {
        var pattern = new RegExp(/^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?$/i);      
        if(!pattern.test(emailAddress)) {             
            dia.jqm.messageBox(dia.localizedStrings.msg_AdresseEmailInvalide);
            return false;
        }
    }
    return true;
};
/*
 * roundNumber : Arrondi avec deux décimales
 */
dia.jqm.roundNumber = function ( number ) {
    var newnumber = new Number(number+'').toFixed(parseInt(1));
    newnumber =  parseFloat(newnumber);
    newnumber = newnumber.toFixed(parseInt(2));
    return newnumber;
};
/*
 * isNumeric : retourne TRUE si valeur numérique
 */
dia.jqm.isNumeric = function ( object ) {
    var obj = $(object);
    var sText=obj.val(); 
    var numDecimals = 0;
    var validChars = "0123456789";
    validChars += ".";
    var thisChar;
    var isNumber = true;
    for (var i = 0; i < sText.length && isNumber == true; i++) {
        thisChar = sText.charAt(i);
        if (thisChar == "."){
            numDecimals = numDecimals + 1;
            if (i==0 || i == sText.length-1) isNumber = false;
            if (numDecimals > 1) isNumber = false;
        }
        if (validChars.indexOf(thisChar) == -1) isNumber = false;
    }
    if(!isNumber) {
        obj.val('0');
        obj.focus();
        dia.jqm.messageBox(dia.localizedStrings.msg_valeurNumeric);
    }
};
dia.jqm.messageBox = function ( texte, large ) { 
    $("#idResultat").html(texte);   
    $('#idDialogMessage').css("visibility", "visible");  
    if(large){
        $("#idDialogMessage").dialog({modal: true, width: 600, stack: false, buttons: { Ok: function() { $( this ).dialog( "close" ); }}});
    }
    else {
        $("#idDialogMessage").dialog({modal: true, width: 300, stack: false, buttons: { Ok: function() { $( this ).dialog( "close" ); }}});
    };
};
dia.jqm.setDateFormat = function ( d ) {
    var arr = d.split('-');
    var yr = arr[0];
    var mh = arr[1];
    var dt = arr[2];
    var dateCur=dt+"/"+mh+"/"+yr;
    return dateCur;
};
dia.jqm.validateDate = function ( dtValue ) {
    var dtRegex = new RegExp(/\b\d{1,2}[\/-]\d{1,2}[\/-]\d{4}\b/);
    return dtRegex.test(dtValue);
};
dia.jqm.getURLParameter = function( sParam ) {
    var sPageURL = window.location.search.substring(1);
    var sURLVariables = sPageURL.split('&');
    for (var i = 0; i < sURLVariables.length; i++) {
        var sParameterName = sURLVariables[i].split('=');
        if (sParameterName[0] == sParam) {
            return sParameterName[1];
        }
    }
};
dia.jqm.isInt = function( object ) {
    var obj = $(object)
    var sText=obj.val(); 
    var validChars = "0123456789";
    var thisChar;
    var isNumber = true;
    for (var i = 0; i < sText.length && isNumber == true; i++) {
        thisChar = sText.charAt(i);
        if (validChars.indexOf(thisChar) == -1) isNumber = false;
    }
    if(!isNumber) {
        obj.val('0');
        obj.focus();
        dia.jqm.messageBox(dia.localizedStrings.msg_valeurEntiere);
    }
};

dia.jqm.gotoTop = function ( ) {
    $(document.body).animate({scrollTop: $('.container').offset().top}, 1000, 'easeInOutCubic');
};
dia.jqm.gotoAncre = function ( ancre ) {
    $(document.body).animate({scrollTop: $(ancre).offset().top}, 1000, 'easeInOutCubic');//,'slow');
};

dia.jqm.initEditionPage = function ( ) {
    if(dia.jqm.getCookie('kmc')==dia.typeAcces.ADMINISTRTEUR) {
        $(".imgEditer").each(function(){$(this).show();});
    }
    else {
        $(".imgEditer").each(function(){$(this).hide();});
    }
};
dia.jqm.reverseArr = function ( input ) {
    var j=0;
    var ret = new Array;   
    for(var i = input.length-1; i >= 0; i--) {
//        ret.push([j++, input[i][1]]);
        ret.push([input[i][0], input[i][1]]);
        j++;
    }      
    return ret;
};
/*
 * ConversionUnite mmol/l - g/dl - g/l
 */
dia.jqm.conversionUnite = function ( ) {
    var dl, l;
    var msg="";
    for (var i=1; i<30; i++) {
        dl = (i*18);
        l = (i*0.18);
        msg+="<tr><td>"+i+"</td><td>"+dl.toFixed(0)+"</td><td>"+l.toFixed(2)+"</td></tr>";
    }
    $('#idConversion').html(msg);
};
dia.jqm.ajaxCall = function ( active ) {
    if(active){
        $(document).bind("ajaxStart.mine", function() {
            $('#idLoader').show();
        });
        $(document).bind("ajaxStop.mine", function() {
            $('#idLoader').hide();
        });
    }
    else {
        $(document).unbind(".mine");
        $('#idLoader').hide();
    }
};
dia.jqm.loadPage = function ( page, direct ) {
    if(!direct && (page=='data/data.jsp' || page=='application/configuration.jsp')){
        if(dia.jqm.getCookie('kmc')==dia.typeAcces.MEDECIN){
            //dia.patient.initLstPatient('data/data.jsp');
            //dia.patient.getPatient('data/data.jsp');
            dia.patient.selectPatient(page);
        }
        else {
            dia.jqm.ajaxCall(true);
            dia.jqm.clearAllMenu();
            $('#tabContainer').load(page);
            dia.jqm.activelMenu(page);
        }
    }
    else {
        dia.jqm.ajaxCall(true);
        dia.jqm.clearAllMenu();
        $('#tabContainer').load(page);
        dia.jqm.activelMenu(page);
    }
    //if(dia.jqm.getCookie('kmc')==dia.typeAcces.MEDECIN){
    //    //dia.patient.initLstPatient('data/data.jsp');
    //    //dia.patient.getPatient('data/data.jsp');
    //    dia.patient.selectPatient(page);
    //}
    //else {
    //    dia.jqm.ajaxCall(true);
    //    dia.jqm.clearAllMenu();
    //    $('#tabContainer').load(page);
    //    dia.jqm.activelMenu(page);
    //}
};
dia.jqm.activelMenu = function ( page ) {
    if (page == 'data/data.jsp'){$( "#idMesDonnees" ).addClass( "active" );}
    if (page == 'application/configuration.jsp'){$( "#idMaConfiguration" ).addClass( "active" );}
    if (page == 'accueil/password.jsp'){$( "#idChangePassword" ).addClass( "active" );}
    if (page == 'accueil/accueil.jsp'){$( "#idMenuAccueil" ).addClass( "active" );}
    if (page == 'application/presentation.jsp'){$( "#idMenuApplication" ).addClass( "active" );}
    if (page == 'application/conversion.jsp'){$( "#idMenuConversion" ).addClass( "active" );}
    if (page == 'application/lien.jsp'){$( "#idMenuLien" ).addClass( "active" );}
    if (page == 'accueil/aProposDe.jsp'){$( "#idMenuAProposDe" ).addClass( "active" );}
    if (page == 'accueil/contact.jsp'){$( "#idMenuContact" ).addClass( "active" );}
    if (page == 'accueil/partenaires.jsp'){$( "#idMenuPartenaire" ).addClass( "active" );}
    if (page == 'accueil/donation.jsp'){$( "#idMenuDonation" ).addClass( "active" );}
    
    
};
dia.jqm.clearAllMenu = function ( ) {
    if($( "#idMesDonnees" ).hasClass( "active" )){$( "#idMesDonnees" ).removeClass( "active" );}
    if($( "#idMaConfiguration" ).hasClass( "active" )){$( "#idMaConfiguration" ).removeClass( "active" );}
    if($( "#idChangePassword" ).hasClass( "active" )){$( "#idChangePassword" ).removeClass( "active" );}
    if($( "#idMenuAccueil" ).hasClass( "active" )){$( "#idMenuAccueil" ).removeClass( "active" );}
    if($( "#idMenuApplication" ).hasClass( "active" )){$( "#idMenuApplication" ).removeClass( "active" );}
    if($( "#idMenuConversion" ).hasClass( "active" )){$( "#idMenuConversion" ).removeClass( "active" );}
    if($( "#idMenuLien" ).hasClass( "active" )){$( "#idMenuLien" ).removeClass( "active" );}
    if($( "#idMenuAProposDe" ).hasClass( "active" )){$( "#idMenuAProposDe" ).addClass( "active" );}
    if($( "#idMenuContact" ).hasClass( "active" )){$( "#idMenuContact" ).removeClass( "active" );}
    if($( "#idMenuPartenaire" ).hasClass( "active" )){$( "#idMenuPartenaire" ).removeClass( "active" );}
    if($( "#idMenuDonation" ).hasClass( "active" )){$( "#idMenuDonation" ).removeClass( "active" );}
};
