'use strict';
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

var d1 = [];
var d2 = [];
var d3 = [];
var d4 = [];
var nMin = 0;
var nMax = 0;
var dateCur;
var plotPt;
var moyenne=0;
var dataDisplay;
var label;// = ["Glycémie", "Min.    ","Max.    ","Moyenne"];

var idData=0;
var choiceContainer;
var previousPoint;
var reload;

var patient=0;

dia.data.init = function ( pt ) {
    patient=pt;
    idData=0;
    dataDisplay = [];
    
    label = [dia.localizedStrings.msg_glycemie, dia.localizedStrings.msg_minimum, dia.localizedStrings.msg_maximum, dia.localizedStrings.msg_moyenne];    
    
    $('#idDivPatient').hide();

    dia.data.setMinMaxTime();

    $("#idDateDebut").datepicker({
        buttonImage: 'ressources/images/layout/calendar.png',
        buttonImageOnly : true,
        dateFormat: "dd/mm/yy",
        showOn : 'button'
    });
    $("#idDateFin").datepicker({
        buttonImage: 'ressources/images/layout/calendar.png',
        buttonImageOnly : true,
        dateFormat: "dd/mm/yy",
        showOn : 'button'
    });
    $('#idDateFin').datepicker('setDate', new Date());
    $('#idDateDebut').datepicker('setDate', '-7');       

    choiceContainer = $("#idChoix");
    previousPoint = null;
    reload = false;
    dataDisplay = [];

    $('#tab-container').easytabs();

    dia.data.initData( );
    
    // Ajuste la largeeur des graph.
    var width = $('#idRechercheData').width();
    $('#idGraphMesData').width(width);
    $('#idGraphMesDataHoraire').width(width);
    
    
    if(dia.jqm.getCookie("kmc")==dia.typeAcces.ADMINISTRTEUR){
        dia.data.initImportData();         
        $('#idAffJour').show();
        $('#idCheckByDay').show();
        $('#idBoutonImporter').show();
    }
    else {
        $('#idAffJour').hide();
        $('#idCheckByDay').hide();
        $('#idBoutonImporter').hide();
    }
};
dia.data.initData = function ( ) {
    dia.data.initTrancheHoraire();
    if(patient && patient===1){
        $('#idBoutonAjouter').hide();
        $('#idBoutonDetail').hide();
        $('#idBoutonSupprimer').hide();
    }
    else {
        $('#idBoutonAjouter').show();
        $('#idBoutonDetail').show();
        $('#idBoutonSupprimer').show(); 
    }
    dia.data.getDataInjection();
};
dia.data.initTrancheHoraire = function( ) {
    var items = [ 
                    { id: 'u0', nom: dia.localizedStrings.msg_tous },
                    { id: 'u1', nom: dia.localizedStrings.msg_petitDejeuner },
                    { id: 'u2', nom: dia.localizedStrings.msg_collation10h },
                    { id: 'u3', nom: dia.localizedStrings.msg_dejeuner },
                    { id: 'u4', nom: dia.localizedStrings.msg_collation16h },
                    { id: 'u5', nom: dia.localizedStrings.msg_diner },
                    { id: 'u6', nom: dia.localizedStrings.msg_collationSoir }
                ];
    $.each(items,function(i,item){  
        $("#idTrancheHoraire").append("<option value='"+item.id+"'>"+item.nom+"</option>");
    });

    $("#idGridMesDataHoraire").flexigrid({
        dataType : 'json',
        colModel : [
                {display: 'Date', name : 'dateInj', width : 80, sortable : true, align: 'left'},
                {display: dia.localizedStrings.msg_petitDejeuner, name : 'g1', width : 100, sortable : true, align: 'center'},
                {display: dia.localizedStrings.msg_collation10h, name : 'g2', width : 100, sortable : true, align: 'center'},
                {display: dia.localizedStrings.msg_dejeuner, name : 'g3', width : 100, sortable : true, align: 'center'},
                {display: dia.localizedStrings.msg_collation16h, name : 'g4', width : 100, sortable : true, align: 'center'},
                {display: dia.localizedStrings.msg_diner, name : 'g5', width : 100, sortable : true, align: 'center'},
                {display: dia.localizedStrings.msg_collationSoir, name : 'g6', width : 100, sortable : true, align: 'center'}
                ],
        singleSelect: true,
        height: 500
    }); 
};
dia.data.deleteData = function ( ) {    
    if(idData && idData>0) {
        $('#idDialogSupprimerData').css("visibility", "visible");
        
        var buttons = [];
        buttons['OK'] = dia.localizedStrings.msg_ok;
        buttons['Cancel'] = dia.localizedStrings. msg_annuler;
    
        var buttonArray = {};
        buttonArray[buttons['OK']] = function() {
            var token = dia.jqm.getCookie("token");
            var request = $.ajax({url: dia.servlet+"injection?d="+idData+"&t="+token, type : 'DELETE'});
            request.done(function() {
                idData = 0;
                dia.data.getDataInjectionReload();
            });
            request.fail(function(jqXHR) {
                idData = 0;
                dia.jqm.messageBox($(jqXHR.responseText).filter('p:eq(1)').find('u').text());
            });                    
            $( this ).dialog( "close" );
        };
        buttonArray[buttons['Cancel']] = function() {
            $(this).dialog('close');
        };
    
        
        $( "#idDialogSupprimerData" ).dialog({modal: true,
            buttons: buttonArray
//            buttons: { 
//                "Ok": function() { 
//                    var request = $.ajax({url: dia.servlet+"injection?d="+idData,type : 'DELETE'});
//                    request.done(function() {
//                        idData = 0;
//                        dia.data.getDataInjectionReload();
//                    });
//                    request.fail(function(jqXHR) {
//                        idData = 0;
//                        dia.jqm.messageBox($(jqXHR.responseText).filter('p:eq(1)').find('u').text());
//                    });                    
//                    $( this ).dialog( "close" ); 
//                }, 
//                "Annuler": function() { 
//                    $( this ).dialog( "close" ); 
//                }
//            }
        });
    }
    else {
        dia.jqm.messageBox(dia.localizedStrings.msg_select_data);
    }
};
dia.data.getMesData = function ( idData ) {
   if(idData && idData>0) {
        var request = $.ajax({url: dia.servlet+"injection", type : 'GET', data: {'idData': idData}});
        request.done(function(newStore) {
            newStore = JSON.parse(newStore);
            dia.data.getDetailData(newStore);
        });
        request.fail(function(jqXHR) {
            if($(jqXHR.responseText).filter('p:eq(1)').find('u').text()){
                dia.jqm.messageBox($(jqXHR.responseText).filter('p:eq(1)').find('u').text());
            }
            else  {
                dia.jqm.messageBox(dia.localizedStrings.msg_erreurConnexionServeur);
            }
        });
   }
   else {
       dia.data.getDetailData();
   }
};
dia.data.getDetailData = function ( row ) {
   var data=new Object();

   $('#idDialogSaisieData').css("visibility", "visible");
   
   if(row) {
       $('#idSaisieDateHeure').html(dia.jqm.setDateFormat(row.dateInj) + " - " + row.timeInj);
       $('#idSaisieQuantiteHdc').val(row.nbHdc);
       $('#idSaisieGlycemie').val(row.glycemie);
       $('#idSaisieInjection').val(row.injection);
       $('#isSaisieCommentaire').val(row.commentaire);            
   }
   else {
       $('#idSaisieDateHeure').html("<input type='text' readonly id='idSaisieDate' size='10' /> <input type='text' id='idSaisieHeure' size='5' />");
       $("#idSaisieDate").datepicker({
           buttonImage: 'ressources/images/layout/calendar.png',
           buttonImageOnly : true,
           dateFormat: "dd/mm/yy",
           showOn : 'button'
       });
       $('#idSaisieDate').datepicker('setDate', $.now());

//            $('#idSaisieHeure').timepicker('show');
       $('#idSaisieHeure').timepicker({ 'timeFormat': 'H:i' });
       $('#idSaisieHeure').timepicker('setTime', new Date());            
   }

    var buttons = [];
    buttons['OK'] = dia.localizedStrings.msg_ok;
    buttons['Cancel'] = dia.localizedStrings. msg_annuler;
    
    var buttonArray = {};
    buttonArray[buttons['OK']] = function() {
        data.nbHdc=parseFloat($('#idSaisieQuantiteHdc').val());
        if(!data.nbHdc){data.nbHdc=0;}
        data.glycemie=parseFloat($('#idSaisieGlycemie').val()); 
        if(!data.glycemie){data.glycemie=0;}
        data.injection=parseFloat($('#idSaisieInjection').val());
        if(!data.injection){data.injection=0;}
        data.commentaire=$('#isSaisieCommentaire').val();        
        if(row) {
            data.id=row.id;
            data.dateInj=row.dateInj;
            data.timeInj=row.timeInj;
        }
        else {
            data.id=0;
            var dt=$("#idSaisieDate").val();
            var tableau=dt.split("/");
            data.dateInj=tableau[2]+"-"+tableau[1]+"-"+tableau[0];
            data.timeInj=$('#idSaisieHeure').val();
        }
        dia.data.updateDataInjection(data.id, data.dateInj, data.timeInj, data.nbHdc, data.glycemie, data.injection, data.commentaire);
        $( this ).dialog( "close" );
        dia.data.getDataInjectionReload();
    };
    buttonArray[buttons['Cancel']] = function() {
        $(this).dialog('close');
    };
    
   $("#idDialogSaisieData").dialog({
       height: 350,
       width: 500,
       modal: true,
       buttons: buttonArray
//       buttons: {
//           "Ok": function() {
//               data.nbHdc=parseFloat($('#idSaisieQuantiteHdc').val());
//               if(!data.nbHdc){data.nbHdc=0;}
//               data.glycemie=parseFloat($('#idSaisieGlycemie').val()); 
//               if(!data.glycemie){data.glycemie=0;}
//               data.injection=parseFloat($('#idSaisieInjection').val());
//               if(!data.injection){data.injection=0;}
//               data.commentaire=$('#isSaisieCommentaire').val();        
//               if(row) {
//                   data.id=row.id;
//                   data.dateInj=row.dateInj;
//                   data.timeInj=row.timeInj;
//               }
//               else {
//                   data.id=0;
//                   var dt=$("#idSaisieDate").val();
//                   var tableau=dt.split("/");
//                   data.dateInj=tableau[2]+"-"+tableau[1]+"-"+tableau[0];
//                   data.timeInj=$('#idSaisieHeure').val();
//               }
//               dia.data.updateDataInjection(data.id, data.dateInj, data.timeInj, data.nbHdc, data.glycemie, data.injection, data.commentaire);
//               $( this ).dialog( "close" );
//               dia.data.getDataInjectionReload();
//           },
//           "Annuler": function() {
//               $( this ).dialog( "close" );
//           }
//       }
   });
};
dia.data.setMinMaxTime = function ( ) {
    var d = new Date();
    var yr = d.getFullYear();
    var mh = d.getMonth()+1;
    var dt = d.getDate();
    dt = ("0" + dt).slice(-2);
    mh = ("0" + mh).slice(-2);
    dateCur=yr+"/"+mh+"/"+dt;
    var dtMin = new Date(dateCur+" 00:00");
    var dtMax = new Date(dateCur+" 00:00");
    nMax = dtMax.setDate(dtMin.getDate()+1) - (d.getTimezoneOffset() * (1000*60));
    nMin = dtMin.getTime() - (d.getTimezoneOffset() * (1000*60));
};
dia.data.getDataInjectionReload = function( ) {
    var idUtilisateur="0";
    reload = true;
    if(patient && patient===1){
        idUtilisateur = dia.utiPatient.id;
    }
    var idTrancheHoraire = $("#idTrancheHoraire").val();
    var glycemieAuto = 0;
    if($('#idGlycemieAuto').is(':checked')) glycemieAuto = 1;
    var sDebut = $("#idDateDebut").val();
    var sFin = $("#idDateFin").val();
    $('#idGridMesData').flexOptions({url: dia.servlet+"injection?u="+idUtilisateur+"&g="+glycemieAuto+"&t="+idTrancheHoraire+"&d="+sDebut+"&f="+sFin}).flexReload();
};
dia.data.getDataInjection = function( ) {
    var idUtilisateur = "";
    if(patient && patient===1){
        idUtilisateur = dia.utiPatient.id;
    }
    var idTrancheHoraire = $("#idTrancheHoraire").val();
    var glycemieAuto = 0;
    if($('#idGlycemieAuto').is(':checked')) glycemieAuto = 1;
    var sDebut = $("#idDateDebut").val();
    var sFin = $("#idDateFin").val();
    $("#idGridMesData").flexigrid({
        url: dia.servlet+"injection?u="+idUtilisateur+"&g="+glycemieAuto+"&t="+idTrancheHoraire+"&d="+sDebut+"&f="+sFin,
        method : 'GET',
        dataType: 'json',
        colModel : [
                {display: dia.localizedStrings.msg_date, name : 'dateInj', width : 80, sortable : true, align: 'left', process: dia.data.selectRow},                
                {display: dia.localizedStrings.msg_heure, name : 'timeInj', width : 100, sortable : true, align: 'left', process: dia.data.selectRow},                
                {display: dia.localizedStrings.msg_nbHdc, name : 'nbHdc', width : 100, sortable : true, align: 'right', process: dia.data.selectRow},                
                {display: dia.localizedStrings.msg_glycemie, name : 'glycemie', width : 100, sortable : true, align: 'right', process: dia.data.selectRow},                
                {display: dia.localizedStrings.msg_injection, name : 'injection', width : 100, sortable : true, align: 'right', process: dia.data.selectRow},                
                {display: dia.localizedStrings.msg_commentaire, name : 'commentaire', width : 200, sortable : true, align: 'left', process: dia.data.selectRow}                
                ],
        singleSelect: true,
        height: 500,
        preProcess: dia.data.insertMesData
    }); 
    $('#idGridMesData').click(function(event) {
        $("#idBoutonDetail").removeAttr("disabled");
        $("#idBoutonSupprimer").removeAttr("disabled");
    });
};
dia.data.selectRow = function( celDiv, id ) {
    $(celDiv).click(function() {
        idData = id;
    });
};
dia.data.insertMesData = function ( data ) {
    var rows=Array();
    dia.data.insertMesDataHoraire(data);
    dia.data.insertMesDataGraph(data);
    dia.data.insertMesDataGraphHoraire(data);
    
    $.each(data,function(i,row){
        if(row.id>0) {
            if(row.commentaire) rows.push({id:row.id, cell:[dia.jqm.setDateFormat(row.dateInj), row.timeInj, row.nbHdc, row.glycemie, row.injection, row.commentaire]});
            else rows.push({id:row.id, cell:[dia.jqm.setDateFormat(row.dateInj), row.timeInj, row.nbHdc, row.glycemie, row.injection, ""]});
        }
    });
    return { total: data.length, page: 1, rows: rows };
};
dia.data.insertMesDataHoraire = function ( data ) {
    var dt;
    var rows = Array();
    var dtData='2000-00-00';
    var g1=0, g2=0, g3=0, g4=0, g5=0, g6=0;

    $.each(data,function(i,row){
        if(row.id>0) {
            dt = dia.jqm.setDateFormat(row.dateInj);
            if(dtData!=row.dateInj){                    
                if(g1>0 || g2>0 || g3>0 || g4>0 || g5>0 || g6>0){
                    rows.push({cell: [dia.jqm.setDateFormat(dtData), g1, g2, g3, g4, g5, g6]});
                }
                g1=0;
                g2=0;
                g3=0;
                g4=0;
                g5=0;
                g6=0;
                dtData = row.dateInj;
            }
            switch(row.repas){
                case 1: g1=row.glycemie; break;
                case 2: g2=row.glycemie; break;
                case 3: g3=row.glycemie; break;
                case 4: g4=row.glycemie; break;
                case 5: g5=row.glycemie; break;
                case 6: g6=row.glycemie; break;
            }               
        }
    });
    $('#idGridMesDataHoraire').flexAddData({total: rows.length,page:1,rows:rows});
};
dia.data.insertMesDataGraph = function ( data ) {
    var lg = 0;
    d1 = [];
    d2 = [];
    d3 = [];
    d4 = [];
    moyenne=0;
    $.each(data,function(i,row){              
        if(row.id>0) {               
            lg++;
            var d = new Date(row.dateInj+" "+row.timeInj);
            d1.push([d.getTime(), row.glycemie]);
//            d1.push([i, row.glycemie] );
            moyenne += row.glycemie;
        }
    });             

    var uGly = dia.config.getUniteGlycemie();
    if(uGly==null) uGly=1;
    var valHaut=10.0;
    var valBas=5.0;
    if(uGly==2) {
        valHaut=180;
        valBas=90;
    }
    else if(uGly==3) {
        valHaut=1.8;
        valBas=0.9;
    }    

    d1=dia.jqm.reverseArr(d1);    
    if(lg>0) {     
        moyenne = moyenne / lg;
        d2.push([d1[0][0], valBas]);
        d3.push([d1[0][0], valHaut]);
        d4.push([d1[0][0], moyenne]);
        d2.push([d1[lg-1][0], valBas]);
        d3.push([d1[lg-1][0], valHaut]);
        d4.push([d1[lg-1][0], moyenne]);
    }
    dia.data.setChoix();
    dia.data.plotChoix();
}; 
dia.data.insertMesDataGraphHoraire = function ( data ) {
    var lg = 0;
    var n = 0;

    var dValide = [];
    var dMin = [];
    var dMax = [];
    var dataSet=[];
    var dMoyenne=[];
    var moyenne=0;
    
    dataDisplay=[];
    
    var uGly = dia.config.getUniteGlycemie();
    if(uGly==null) uGly=1;
    var max=20;
    var valHaut=10.0;
    var valBas=5.0;
    if(uGly==1) {
        max=20;
    }
    else if(uGly==2) {
        max=360; //=20*18;
        valHaut=180;
        valBas=90;
    }
    else if(uGly==3) {
        max=4; // environ 20*0.18;
        valHaut=1.8;
        valBas=0.9;
    }    
    
    $.each(data,function(i,row){
        if(row.id>0 && row.glycemieCapteur==0) {
            var d = new Date(dateCur+" "+row.timeInj);
            if(!isNaN(d)){
                lg++;
                n = d.getTime() - (d.getTimezoneOffset() * (1000*60));
                if(row.glycemie>20) dataSet.push([n, 20.0]);
                else dataSet.push([n, row.glycemie]);
                moyenne += row.glycemie;
            }
        }
    });

    if(lg>0) {
        moyenne = moyenne / lg;
        dValide.push([nMin, valBas]);
        dValide.push([nMax, valBas]);
        dMoyenne.push([nMin, moyenne]);
        dMoyenne.push([nMax, moyenne]);
        dMin.push([nMin, valBas]);
        dMin.push([nMax, valBas]);
        dMax.push([nMin, valHaut]);
        dMax.push([nMax, valHaut]);
    }

    if (dataSet.length > 0) {
        var dataDisplay = [
            {
                label: label[0],
                data: dataSet,
                points: { symbol: "circle", show: true }
            },
            {
                data: dValide,
                color: "#E1FFCF",
                bars: { horizontal: true, show: true, barWidth: 5, fillColor: { colors: [{ opacity: 0.1 }, { opacity: 0.5}] }}
            },
            {
                label: label[3],
                data: dMoyenne,
                color: "#166AE6",
                lines: { show: true }
            },
            {
                data: dMin,
                color: "#BA8C8C",
                lines: { show: true }
            },
            {
                data: dMax,
                color: "#BA8C8C",
                lines: { show: true }
            }
        ];
        
        plotPt = $.plot($('#idGraphMesDataHoraire'), dataDisplay,
            {series: {points: { show: true }},
                grid: { 
                    backgroundColor: { colors: ["#fff", "#eee"]}}, 
                    yaxis: { min:0, max: max,  tickSize: 5 }, 
                    xaxis: { mode: "time", minTickSize: [1, "hour"], min: nMin, max: nMax, timeformat: "%0H:%0M" }});
    }
    else {
        $('#idGraphMesDataHoraire').html("<span style=\"font-size:25px;color:#666\">"+dia.localizedStrings.msg_noData+"<span>");
    }
};
/*
 * Affichage des checkbox du graph permettant d'afficher les donnees
 */
dia.data.setChoix = function ( ) {
    if(!reload) {
        $.each(label, function(i, text) {
            choiceContainer.append('&nbsp;&nbsp;&nbsp;<input type="checkbox" name="' + i +
                                   '" checked="checked" id="id' + i + '">&nbsp;&nbsp;&nbsp;' +
                                   '<span for="id' + i + '">' + text + '</span>');
        });
        choiceContainer.find("input").click(dia.data.plotChoix);
    }
};
dia.data.plotChoix = function ( ) {
    dataDisplay = [];
    choiceContainer.find("input:checked").each(function () {
        var key = $(this).attr("name");
        if(key) {
            if (key==0) dataDisplay.push({label: label[0], data: d1});
            else if (key==1) dataDisplay.push({label: label[1], data: d2});
            else if (key==2) dataDisplay.push({label: label[2], data: d3});
            else if (key==3) dataDisplay.push({label: label[3], data: d4});
        }
    });   
  
    if (dataDisplay.length > 0) {
        $("<div id='tooltip'></div>").css({
            position: "absolute",
            display: "none",
            border: "1px solid #fdd",
            padding: "2px",            
            'background-color': "#fee",
            opacity: 0.80
        }).appendTo("body");
        
        $.plot($("#idGraphMesData"), dataDisplay, 
            {series: {
                    lines: { show: true },
//                    points: { show: true },
                    curvedLines: {
                        apply: true,
                        active: true,
                        monotonicFit: true
                    }
            },
            grid: { 
                backgroundColor: { colors: ["#fff", "#eee"] },
                hoverable: true
//                    clickable: true
            },
//                grid: { backgroundColor: { colors: ["#fff", "#eee"]}},
            xaxis: {ticks: []}
//                yaxis: {
//                },
//                xaxis: { mode: "time",minTickSize: [1, "hour"],
//                        min: (new Date("2000/01/01")).getTime(),
//                        max: (new Date("2000/01/02")).getTime()}
        });
                
        $("#idGraphMesData").bind("plothover", function (event, pos, item) {
            if (item) {
                var x = item.datapoint[0],
                    y = item.datapoint[1].toFixed(2); 
                    
                var d = new Date(x);
                var strDate = ("00" + d.getDate()).slice(-2) + "/" + 
                    ("00" + (d.getMonth() + 1)).slice(-2) + "/" + 
                    d.getFullYear() + " " + 
                    ("00" + d.getHours()).slice(-2) + ":" + 
                    ("00" + d.getMinutes()).slice(-2) + ":";
                    
                $("#tooltip").html( y + " - " + strDate)
                    .css({top: item.pageY+5, left: item.pageX+15})
                    .fadeIn(100);
            }
            else {
                $("#tooltip").html( "" );
            }
        });                
    }
};
dia.data.exportCsv = function ( ) {
    var idUtilisateur = 0;
    var glycemieAuto = 0;
    var sDebut = $("#idDateDebut").val();
    var sFin = $("#idDateFin").val();
    var idTrancheHoraire = $("#idTrancheHoraire").val();//data("kendoDropDownList").value();
    
    if(patient && patient===1){
        idUtilisateur = dia.utiPatient.id;
    }

    document.location.href = dia.servlet + "export?"
        + "u=" + idUtilisateur + "&"
        + "g=" + glycemieAuto + "&"
        + "t=" + idTrancheHoraire + "&"
        + "d=" + sDebut + "&"
        + "f=" + sFin + "&"
    ;

    //var request = $.ajax({url: dia.servlet+"export",type : 'GET',
    //    data: { 'u': idUtilisateur,
    //            'g': glycemieAuto,
    //            't': idTrancheHoraire,
    //            'd': sDebut,
    //            'f': sFin
    //       }
    //});
    //request.fail(function(jqXHR) {
    //    dia.jqm.messageBox($(jqXHR.responseText).filter('p:eq(1)').find('u').text());
    //});
};
dia.data.updateDataInjection = function (id, dateInj, timeInj, nbHdc, glycemie, injection, commentaire) {
    var storeData = [];
    var data=new Object();
    data.dateInj=dateInj;
    data.id=id;
    data.timeInj=timeInj;
    data.nbHdc=nbHdc; 
    data.glycemie=glycemie; 
    data.injection=injection;
    data.commentaire=commentaire;
    storeData.push(data);

    var token = dia.jqm.getCookie("token");
    var request = $.ajax({url: dia.servlet+"injection",type : 'POST',data: {'n': JSON.stringify(storeData), t: token}});
    request.done(function() {
        dia.jqm.ajaxCall(false);
        dia.data.getDataInjection();
//        dia.data.getDataInjectionReload();
    });
    request.fail(function(jqXHR) {
        if($(jqXHR.responseText).filter('p:eq(1)').find('u').text()){
            dia.jqm.messageBox($(jqXHR.responseText).filter('p:eq(1)').find('u').text());
            dia.jqm.ajaxCall(false);
        }
        else  {
            dia.jqm.messageBox(dia.localizedStrings.msg_erreurConnexionServeur);
        }
    });
};
dia.data.initImportData = function ( ) {
    $('#idFormImportData').on('submit', function (e) {         
        // On empêche le navigateur de soumettre le formulaire
        e.preventDefault();
    
        var $form = $(this);
        var formdata = (window.FormData) ? new FormData($form[0]) : null;
        var data = (formdata !== null) ? formdata : $form.serialize();
 
        $.ajax({
            url: dia.servlet + "import",
            type: 'POST',
            contentType: false, // obligatoire pour de l'upload
            processData: false, // obligatoire pour de l'upload
            dataType: 'json', // selon le retour attendu
            data: data,
            success: function (nbData) {
                dia.jqm.ajaxCall(false);                
                dia.jqm.messageBox(dia.localizedStrings.msg_data_transfert + ": " + nbData);
            },
            error: function (jqXHR) {
                if($(jqXHR.responseText).filter('p:eq(1)').find('u').text()){
                    dia.jqm.messageBox($(jqXHR.responseText).filter('p:eq(1)').find('u').text());
                    dia.jqm.ajaxCall(false);
                }
                else  {
                    dia.jqm.messageBox(dia.localizedStrings.msg_erreurConnexionServeur);
                }
            }
        });    
    });
};
dia.data.affImportData = function ( ) {    
    $('#idImportData').css("visibility", "visible");
    
    var buttons = [];
    buttons['OK'] = dia.localizedStrings.msg_ok;
    buttons['Cancel'] = dia.localizedStrings. msg_annuler;
    
    var buttonArray = {};
    buttonArray[buttons['OK']] = function() {
        $( this ).dialog( "close" );
        dia.jqm.ajaxCall(true);                
        $( "#idFormImportData" ).submit();
    };
    buttonArray[buttons['Cancel']] = function() {
        $(this).dialog('close');
    };
    
    $( "#idImportData" ).dialog({modal: true,
        width: 650,
        height: 350,
        show: {
            effect: "blind",
            duration: 500
        },
        buttons: buttonArray
//        buttons: { 
//            "Ok": function() {  
//                $( this ).dialog( "close" );
//                dia.jqm.ajaxCall(true);                
//                $( "#idFormImportData" ).submit();
//            }, 
//            "Annuler": function() { 
//                $( this ).dialog( "close" ); 
//            }
//        }
    });
};
dia.data.checkByDay = function ( ) {    
    if($('#idCheckByDay').is(':checked')){
        $('#idMsgA').hide();
        $("#idDateFin").val("");
        $('#idDateFin').hide();
        $('#idDateFin').datepicker("destroy");
        
//        $('#panel-container').tabs({active: 2});
        
//        $('#idDataTab1').hide();
//        $('#idDataTab2').hide();
//        $('#idDataTab4').hide();
    }
    else {
        $('#idMsgA').show();
        $('#idDateFin').show();
        $("#idDateFin").datepicker({
            buttonImage: 'ressources/images/layout/calendar.png',
            buttonImageOnly : true,
            dateFormat: "dd/mm/yy",
            showOn : 'button'
        });
        $('#idDateFin').datepicker('setDate', new Date());

//        $('#idDataTab1').show();
//        $('#idDataTab2').show();
//        $('#idDataTab4').show();
    }
};
