'use strict';
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

dia.connexion.init = function ( ) {
    $('#idMenuConnecte').hide();
    $("#idConnexion").html('<img src=\"./ressources/images/connexion/connexion.png\" height=\"25\" title="'+dia.localizedStrings.index_connexion+'\"/>');
    $("#idConnexion").unbind('click');
    $("#idConnexion").bind('click',function() {dia.main.connexion();});
};
dia.connexion.connexion = function ( email, pass ) {
    var bConnexion=true;
    var nom = $("#idUsername").val();
    var password = $("#idPassword").val();
    
    if(email){nom = email;}
    if(pass){password = pass;}

    if (password.length===0) {
        dia.jqm.messageBox(dia.localizedStrings.frm_utilisateur_saisieMotdepasse);
        bConnexion=false;
    }
    else if (nom.length===0) {
        dia.jqm.messageBox(dia.localizedStrings.frm_utilisateur_saisieMail);
        bConnexion=false;            
    }
    else if(!dia.jqm.isValidEmailAddress(nom)){
        bConnexion=false;
    }
    dia.jqm.setCookie("user",nom);

    if(bConnexion){
        var token = dia.jqm.getCookie("token");
        
        var request = $.ajax({url: dia.servlet+"connexion", type : 'POST', data: {'e': nom, 'p':password, t: token }});
        request.done(function(rstUti) {
            dia.connexion.initApp(rstUti); 
            if($('#idDialogInscription').is(":visible")){$('#idDialogInscription').dialog('close');}
            if($('#idDialogLogin').is(":visible")){$('#idDialogLogin').dialog( "close" );}
        });
        request.fail(function(jqXHR) {
            if($(jqXHR.responseText).filter('p:eq(1)').find('u').text()){
                dia.jqm.messageBox($(jqXHR.responseText).filter('p:eq(1)').find('u').text());
            }
            else  {
                dia.jqm.messageBox(dia.localizedStrings.msg_erreurConnexionServeur);
            }
        });
    }
};
dia.connexion.initApp = function ( userStore ) {     
    if(userStore!=null) {
        var user = JSON.parse(userStore);
        
        $('#idUsername').val("");
        $('#idPassword').val("");
        $('#idMesDonnees').show();
        $('#idMenuConnecte').show();        
        $("#idConnexion").html('<img src=\"./ressources/images/connexion/deconnexion.png\" height=\"25\" title="'+dia.localizedStrings.index_deconnexion+'\"/>');
        $("#idConnexion").unbind('click');
        $("#idConnexion").bind('click',function() {dia.connexion.deconnexion();});
        $("#idInscription").hide();
        dia.jqm.setCookie("kmc",user.typeAcces);

        if(user.typeAcces==dia.typeAcces.MEDECIN){
            dia.jqm.loadPage('accueil/accueil.jsp');
        }
        else {
            dia.jqm.loadPage('data/data.jsp');
        }
        dia.connexion.initMembre(user);
    }
    else {
        $('#loginErrorMsg').removeClass("hide");
        $('#idPassword').val("");
        $('#idMenuConnecte').hide();
        $('#idInscription').show();
        dia.idPatientSelect=0;
        dia.connexion.initMembre();
        dia.connexion.deconnexion();
    }            
    return;
};
dia.connexion.deconnexion = function ( ) {
    dia.uti=null;

    $('#idDataPatient').hide();
    $('#idProposerApp').hide();
    $('#idMenuConnecte').hide();
    $('#idGestionPatient').hide();
    $('#idGestionMedecin').hide();
    $('#idInscription').show();
    $("#idConnexion").html('<img src=\"./ressources/images/connexion/connexion.png\" height=\"25\" title=\"<fmt:message key=\'index.connexion\'/>\"/>');
    
    $("#idConnexion").unbind('click');
    $("#idConnexion").bind('click',function() {dia.main.connexion();});    
    $("#idInscription").show();
    $.ajax({url: dia.servlet+"connexion", method : 'DELETE'});
    dia.jqm.delCookie("userDia");
    
    dia.connexion.initMembre();
    dia.jqm.setCookie("kmc",0);
    dia.utiPatient=null;
    dia.idPatientSelect=0;
    
    dia.jqm.loadPage('accueil/accueil.jsp');
};
dia.connexion.initMembre = function ( uti ) {       
    if(uti && uti!=='null') {        
        $('#idMnuMembre').html("Informations");
        $('#idSaisieMotdepasse').hide();
        $("select[name=politesse]").val(uti.sexe);
        $("input[name=nom]").val(uti.nom);
        $("input[name=prenom]").val(uti.prenom);
        $("input[name=mail]").val(dia.jqm.getCookie("user"));

        if(uti.sexe===1){dia.currentUser="M. "+uti.prenom+" "+uti.nom;}
        
        else{dia.currentUser="Mme "+uti.prenom+" "+uti.nom;}
        $("#idUser").html(dia.currentUser);
        
        if(uti.typeAcces==dia.typeAcces.MEDECIN) {
            $('#idProposerApp').show();
            $('#idDataPatient').show();
            $('#idGestionPatient').show();            
            $('#idGestionMedecin').hide();
            
        }
//        else if (uti.typeAcces==dia.typeAcces.ADMINISTRTEUR) {
//            $('#idProposerApp').hide();
//            $('#idDataPatient').show();
//            $('#idGestionMedecin').show();           
//            $('#idGestionPatient').hide();            
//        }
        else {
            $('#idProposerApp').hide();
            $('#idDataPatient').hide();
            $('#idGestionMedecin').show();
            $('#idGestionPatient').hide();
        }
    }
    else {
        dia.idPatientSelect=0;
        $('#idMnuMembre').html("Inscription");
        $('#idSaisieMotdepasse').show();
        $('#idDataPatient').hide();
        $('#idProposerApp').hide();
        $('#idGestionPatient').hide();
        $('#idGestionMedecin').hide();
        $("select[name=politesse]").val(1);            
        $("input[name=nom]").val('');
        $("input[name=prenom]").val('');
        $("input[name=mail]").val('');
        $("#idUser").html("");
    }
};
dia.connexion.password = function ( ) {
    var mail = $('#idUsername').val();
    if (mail.length===0) {
        dia.jqm.messageBox(dia.localizedStrings.frm_utilisateur_saisieMotdepasse);
    }
    else {
        if(dia.jqm.isValidEmailAddress(mail)){
            dia.jqm.ajaxCall(true);
            dia.jqm.setCookie("user",mail);
            var request = $.ajax({url: dia.servlet+"connexion",type : 'GET',data: {'e': mail}});
            request.done(function() {
                dia.jqm.messageBox(dia.localizedStrings.msg_messageEnvoye);
                dia.jqm.ajaxCall(false);
            });
            request.fail(function(jqXHR) {
                if($(jqXHR.responseText).filter('p:eq(1)').find('u').text()){
                    dia.jqm.messageBox($(jqXHR.responseText).filter('p:eq(1)').find('u').text());
                }
                else  {
                    dia.jqm.messageBox(dia.localizedStrings.msg_erreurConnexionServeur);
                }
                dia.jqm.ajaxCall(false);
            });
        }
    }
};
dia.connexion.getKeyCode = function ( event ) {
    if(event.keyCode === 13){
        event.preventDefault();
        dia.connexion.connexion();
    }
};
