'use strict';
/**
 * JQuery Mobile Module
 */

/*
 *
 */

dia.config.init = function ( patient ) {
    if(patient && patient===1){
        dia.config.getDataProfil(dia.utiPatient.id);
    }
    else {
        dia.config.getDataProfil();
    }
};
dia.config.getDataProfil = function( idUtilisateur ) {
    var request = $.ajax({ url: dia.servlet+"profil",type : 'GET',dataType: 'json',data: {'p': idUtilisateur }});
    request.done(function(newStore) {
        newStore=eval(newStore);
        if((newStore.length !== 0)){
            if (typeof idUtilisateur!=="undefined"){
                window.localStorage.setItem('configPatient', JSON.stringify(newStore));
                dia.config.setConfigData(idUtilisateur);
            }
            else {
                window.localStorage.setItem('config', JSON.stringify(newStore));
                dia.config.setConfigData(idUtilisateur);
            }
        }
    });
    request.fail(function(jqXHR) {
        if($(jqXHR.responseText).filter('p:eq(1)').find('u').text()){
            dia.jqm.messageBox($(jqXHR.responseText).filter('p:eq(1)').find('u').text());
        }
        else  {
            dia.jqm.messageBox(dia.localizedStrings.msg_erreurConnexionServeur);
        }
    });
};
dia.config.getConfig = function( valeur ) {
    var storeConfig;
    var returnValeur=0;
    storeConfig = JSON.parse(window.localStorage.getItem('config'));
    if(storeConfig !== null){
        for (var i=0; i<storeConfig.length; i++) {
            if(valeur==='u'){returnValeur = storeConfig[i].unite;}
            else if(valeur==='u1'){returnValeur = storeConfig[i].unite1;}
            else if(valeur==='u2'){returnValeur = storeConfig[i].unite2;}
            else if(valeur==='u3'){returnValeur = storeConfig[i].unite3;}
            else if(valeur==='u4'){returnValeur = storeConfig[i].unite4;}
            else if(valeur==='u5'){returnValeur = storeConfig[i].unite5;}
            else if(valeur==='u6'){returnValeur = storeConfig[i].unite6;}
            else if(valeur==='h1'){returnValeur = storeConfig[i].hdc1;}
            else if(valeur==='h2'){returnValeur = storeConfig[i].hdc2;}
            else if(valeur==='h3'){returnValeur = storeConfig[i].hdc3;}
            else if(valeur==='h4'){returnValeur = storeConfig[i].hdc4;}
            else if(valeur==='h5'){returnValeur = storeConfig[i].hdc5;}
            else if(valeur==='h6'){returnValeur = storeConfig[i].hdc6;}
            else if(valeur==='v'){returnValeur = storeConfig[i].valeur;}
            else if(valeur==='cj'){returnValeur = storeConfig[i].correctionJour;}
            else if(valeur==='cn'){returnValeur = storeConfig[i].correctionNuit;}
            else if(valeur==='a'){returnValeur = storeConfig[i].dureeAction;}
        }
    }
    return returnValeur;
}
dia.config.setDataProfil = function( patient ) {
    var unite = 0;
    var idUtilisateur="0";

    if(patient && patient===1){
        idUtilisateur = dia.utiPatient.id;
    }

    if($('#idUnite01:checked').val()){unite=1;}
    else if($('#idUnite02:checked').val()){unite=2;}
    else if($('#idUnite03:checked').val()){unite=3;}
    var idUnite1 = parseFloat($("#idUnite1").val());
    var idUnite2 = parseFloat($("#idUnite2").val());
    var idUnite3 = parseFloat($("#idUnite3").val());
    var idUnite4 = parseFloat($("#idUnite4").val());
    var idUnite5 = parseFloat($("#idUnite5").val());
    var idUnite6 = parseFloat($("#idUnite6").val());
    var idHdc1 = parseFloat($("#idHdc1").val());
    var idHdc2 = parseFloat($("#idHdc2").val());
    var idHdc3 = parseFloat($("#idHdc3").val());
    var idHdc4 = parseFloat($("#idHdc4").val());
    var idHdc5 = parseFloat($("#idHdc5").val());
    var idHdc6 = parseFloat($("#idHdc6").val());
    var idValeur = parseFloat($("#idValeur").val());
    var idCorrectionJour = parseFloat($("#idCorrectionJour").val());
    var idCorrectionNuit = parseFloat($("#idCorrectionNuit").val());
    var idDureeAction = parseInt($("#idDureeAction").val());
    if(idUnite1!=="" && idUnite2!=="" && idUnite3!=="" && idUnite4!=="" && idUnite5!=="" && idUnite6!=="" && idHdc1!=="" && idHdc2!=="" && idHdc3!=="" && idHdc4!=="" && idHdc5!=="" && idHdc6!=="" && idDureeAction!=="" && idValeur!=="" && idCorrectionJour!=="" && idCorrectionNuit!=="") {
        dia.config.valideConfig(idUtilisateur,unite,idUnite1,idUnite2,idUnite3,idUnite4,idUnite5,idUnite6,idHdc1,idHdc2,idHdc3,idHdc4,idHdc5,idHdc6,idValeur,idCorrectionJour,idCorrectionNuit,idDureeAction);
    }
    else {
        dia.jqm.messageBox(dia.localizedStrings.frm_config_donnees);
    }        
};
dia.config.postConfig = function(idUtilisateur,unite,idUnite1,idUnite2,idUnite3,idUnite4,idUnite5,idUnite6,idHdc1,idHdc2,idHdc3,idHdc4,idHdc5,idHdc6,idValeur,idCorrectionJour,idCorrectionNuit,idDureeAction) {
    var storeData = [];
    var data=new Object();
    
    data.unite=unite;
    data.unite1=idUnite1;
    data.unite2=idUnite2;
    data.unite3=idUnite3;
    data.unite4=idUnite4;
    data.unite5=idUnite5;
    data.unite6=idUnite6;
    data.hdc1=idHdc1;
    data.hdc2=idHdc2;
    data.hdc3=idHdc3;
    data.hdc4=idHdc4;
    data.hdc5=idHdc5;
    data.hdc6=idHdc6;
    data.valeur=idValeur;
    data.correctionJour=idCorrectionJour;
    data.correctionNuit=idCorrectionNuit;
    data.dureeAction=idDureeAction;
    data.idUti=0;
    storeData.push(data);
    
    localStorage.config = JSON.stringify(storeData); 
    
    var token = dia.jqm.getCookie("token");      
    var request = $.ajax({url: dia.servlet+"profil",type : 'POST', data: {p: idUtilisateur, n: localStorage.config, t: token}});
    request.done(function() {
        dia.jqm.messageBox(dia.localizedStrings.frm_config_enregistre);
    });
    request.fail(function(jqXHR) {
        if($(jqXHR.responseText).filter('p:eq(1)').find('u').text()){
            dia.jqm.messageBox($(jqXHR.responseText).filter('p:eq(1)').find('u').text());
        }
        else  {
            dia.jqm.messageBox(dia.localizedStrings.msg_erreurConnexionServeur);
        }
    });
};
dia.config.valideConfig = function(idUtilisateur,unite,idUnite1,idUnite2,idUnite3,idUnite4,idUnite5,idUnite6,idHdc1,idHdc2,idHdc3,idHdc4,idHdc5,idHdc6,idValeur,idCorrectionJour,idCorrectionNuit,idDureeAction) {
    var msg;
    var msgUnite;

    if (idUtilisateur>0){
        msg=dia.localizedStrings.msg_config_validationPatient;
        if(dia.utiPatient.sexe===1){msg += " " + dia.localizedStrings.frm_inscription_monsieur + " " + dia.utiPatient.prenom + " " + dia.utiPatient.nom;}
        else{msg += " " + dia.localizedStrings.frm_inscription_madame + " " + dia.utiPatient.prenom + " " + dia.utiPatient.nom;}        
    }
    else {        
        msg=dia.localizedStrings.msg_config_validation;
    }
    $('#idValideConfigInfo').html(msg);    

    if(unite===1){msgUnite="mmol/l";}
    else if(unite===2){msgUnite="mg/dl";}
    else if(unite===3){msgUnite="g/l";}
    $('#idDialogValideConfigUnite').html(msgUnite);

    $('#idDialogValideConfigValeur').html(idValeur+" "+msgUnite);
    $('#idDialogValideConfigCJ').html(idCorrectionJour+" "+msgUnite);
    $('#idDialogValideConfigCN').html(idCorrectionNuit+" "+msgUnite);
    $('#idDialogValideConfigDI').html(idDureeAction+" mn");
    $('#idDialogValideConfigU1').html(idUnite1+" / "+idHdc1+"   ("+msgUnite+" / hdc)");
    $('#idDialogValideConfigU2').html(idUnite2+" / "+idHdc2+"   ("+msgUnite+" / hdc)");
    $('#idDialogValideConfigU3').html(idUnite3+" / "+idHdc3+"   ("+msgUnite+" / hdc)");
    $('#idDialogValideConfigU4').html(idUnite4+" / "+idHdc4+"   ("+msgUnite+" / hdc)");
    $('#idDialogValideConfigU5').html(idUnite5+" / "+idHdc5+"   ("+msgUnite+" / hdc)");
    $('#idDialogValideConfigU6').html(idUnite6+" / "+idHdc6+"   ("+msgUnite+" / hdc)");

    $('#idDialogValideConfig').css("visibility", "visible");
    
    var buttons = [];
    buttons['OK'] = dia.localizedStrings.msg_ok;
    buttons['Cancel'] = dia.localizedStrings. msg_annuler;
    
    var buttonArray = {};
    buttonArray[buttons['OK']] = function() {
        dia.config.postConfig(idUtilisateur,unite,idUnite1,idUnite2,idUnite3,idUnite4,idUnite5,idUnite6,idHdc1,idHdc2,idHdc3,idHdc4,idHdc5,idHdc6,idValeur,idCorrectionJour,idCorrectionNuit,idDureeAction);
        $( this ).dialog( "close" );
    };
    buttonArray[buttons['Cancel']] = function() {
        $(this).dialog('close');
    };    
    
    $("#idDialogValideConfig").dialog({
        modal: true,
        height: 730,
        width: 500,
        buttons: buttonArray
//        buttons: {
//            "Ok": function() {
//                dia.config.postConfig(idUtilisateur,unite,idUnite1,idUnite2,idUnite3,idUnite4,idUnite5,idUnite6,idHdc1,idHdc2,idHdc3,idHdc4,idHdc5,idHdc6,idValeur,idCorrectionJour,idCorrectionNuit,idDureeAction);
//                $( this ).dialog( "close" );
//            },
//            "Annuler": function() {
//                $( this ).dialog( "close" );
//            }
//        }
    });
}
dia.config.setConfigData = function( utilisateur ) {
    var storeConfig;
    if (typeof utilisateur!=="undefined"){
        storeConfig = JSON.parse(window.localStorage.getItem('configPatient'));
    }
    else {
        storeConfig = JSON.parse(window.localStorage.getItem('config'));
    }
    for (var i=0; i<storeConfig.length; i++) {
        $("#idHdc1").val(storeConfig[i].hdc1);
        $("#idHdc2").val(storeConfig[i].hdc2);
        $("#idHdc3").val(storeConfig[i].hdc3);
        $("#idHdc4").val(storeConfig[i].hdc4);
        $("#idHdc5").val(storeConfig[i].hdc5);
        $("#idHdc6").val(storeConfig[i].hdc6);
        $("#idUnite1").val(storeConfig[i].unite1);
        $("#idUnite2").val(storeConfig[i].unite2);
        $("#idUnite3").val(storeConfig[i].unite3);
        $("#idUnite4").val(storeConfig[i].unite4);
        $("#idUnite5").val(storeConfig[i].unite5);
        $("#idUnite6").val(storeConfig[i].unite6);
        $("#idValeur").val(storeConfig[i].valeur);
        $("#idCorrectionJour").val(storeConfig[i].correctionJour);
        $("#idCorrectionNuit").val(storeConfig[i].correctionNuit);
        $("#idDureeAction").val(storeConfig[i].dureeAction);
        dia.config.setUniteGlycemie(storeConfig[i].unite);
    }
}
dia.config.setUniteGlycemie = function ( unite ) {
    if(!unite || unite===0) { unite = 1; }
    if(unite===1) { $('#idUnite01').attr('checked',true);  $('#idUnite02').attr('checked',false); $('#idUnite03').attr('checked',false); }
    if(unite===2) { $('#idUnite01').attr('checked',false); $('#idUnite02').attr('checked',true);  $('#idUnite03').attr('checked',false); }
    if(unite===3) { $('#idUnite01').attr('checked',false); $('#idUnite02').attr('checked',false); $('#idUnite03').attr('checked',true); }

    if(unite===1) { 
        $('#idValeur').attr('placeHolder', 'mmol/l'); 
        $('#idValeurUnite').html('mmol/l');
        $('#idCorrectionJour').attr('placeHolder', '1u - mmol/l'); 
        $('#idCorrectionUniteJour').html('mmol/l');
        $('#idCorrectionNuit').attr('placeHolder', '1u - mmol/l'); 
        $('#idCorrectionUniteNuit').html('mmol/l');

        $('#idGlycemieSpl').attr('placeHolder', 'Glycémie (mmol/l)'); 
    }
    if(unite===2) { 
        $('#idValeur').attr('placeHolder', 'mg/dl'); 
        $('#idValeurUnite').html('mg/dl');
        $('#idCorrectionJour').attr('placeHolder', '1u - mg/dl'); 
        $('#idCorrectionUniteJour').html('mg/dl');
        $('#idCorrectionNuit').attr('placeHolder', '1u - mg/dl'); 
        $('#idCorrectionUniteNuit').html('mg/dl');

        $('#idGlycemieSpl').attr('placeHolder', 'Glycémie (mg/dl)'); 
    }
    if(unite===3) { 
        $('#idValeur').attr('placeHolder', 'g/l'); 
        $('#idValeurUnite').html('g/l');
        $('#idCorrectionJour').attr('placeHolder', '1u - g/l'); 
        $('#idCorrectionUniteJour').html('g/l');
        $('#idCorrectionNuit').attr('placeHolder', '1u - g/l'); 
        $('#idCorrectionUniteNuit').html('g/l');

        $('#idGlycemieSpl').attr('placeHolder', 'Glycémie (g/l)'); 
    }
};

dia.config.getUniteGlycemie = function( ) {
    var unite;
    unite = dia.config.getConfig("u");
    if(unite > 0) dia.config.setUniteGlycemie(unite);
    else dia.config.setUniteGlycemie(1);
    return dia.config.getConfig("u");
};
dia.config.setSelectTrancheHoraire = function ( ) {
    var d = new Date();
    var hr = d.getHours();
    var mn = d.getMinutes();    
    var tps = (hr*60)+mn;
    var idUnite="";
    var idHdc="";

    var cbx = $("#idSelectRepas").data("kendoDropDownList")

    if(tps>1200 ) { cbx.select(5);idUnite = "u6";;idHdc="h6"; } // 20h00
    else if(tps>1080 ) { cbx.select(4);idUnite = "u5";idHdc="h5"; } // 18h00
    else if(tps>970 ) { cbx.select(3);idUnite = "u4";idHdc="h4"; } // 14h30
    else if(tps>690 ) { cbx.select(2);idUnite = "u3";idHdc="h3"; } // 11h30
    else if(tps>570 ) { cbx.select(1);idUnite = "u2";idHdc="h2"; } // 9h30
    else if(tps>390 ) { cbx.select(0);idUnite = "u1";idHdc="h1"; } // 6h30

    document.getElementById('idUnite').focus();
    (dia.config.getConfig(idUnite) > 0) ? $('#idUnite').val(dia.config.getConfig(idUnite)) : $('#idUnite').val(0);
    (dia.config.getConfig(idHdc) > 0) ? $('#idHdc').val(dia.config.getConfig(idHdc)) : $('#idHdc').val(0);
    (dia.config.getConfig(idUnite) > 0) ? $('#idUniteSpl').val(dia.config.getConfig(idUnite)) : $('#idUniteSpl').val(0);        
    (dia.config.getConfig(idHdc) > 0) ? $('#idHdcSpl').val(dia.config.getConfig(idHdc)) : $('#idHdcSpl').val(0);        
};
