<%@page contentType="text/html" pageEncoding="UTF-8"%>

<%@page import="ch.dia.model.DiaUtilisateur"%>

<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>

<c:set var="language" value="${not empty param.language ? param.language : not empty language ? language : pageContext.request.locale}" scope="session" />
<fmt:setLocale value="${fn:escapeXml(language)}"/>
<fmt:setBundle basename="messages/messages"/>

<!DOCTYPE html>
<html lang="${fn:escapeXml(language)}">
    <head>       
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <meta name="description" content="diabète : cette application permet d'améliorer le contrôle glycémique grâce au calcul du bolus optimal - Un logiciel pour téléphones portables permet aux patients diabétiques d'améliorer leur contrôle glycémique en les aidant à choisir le bolus optimal d'insuline." />
        <meta name="keywords" content="iphone,android,insuline,bolus,calcul,mobile,dib&egrave;te,diabete" />

        <meta name="google-site-verification" content="Zm0NMgu2h6K4uyCKkrHLw3PFwLhDM5ioaB_Jno4hQ9s" />
        
        <link rel="shortcut icon" href="ressources/images/icon.png">
        
	<title>WebDia</title>

        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        
         <!-- Templates core CSS -->
        <link rel="stylesheet" type="text/css" href="css/jquery/bootstrap.css">
        <link rel="stylesheet" type="text/css" href="css/jquery/jquery-ui.css">
        
        <link rel="stylesheet" type="text/css" href="js/grid/flexigrid.css">
        <link rel="stylesheet" type="text/css" href="js/tabs/tabs.css">
        
        <link rel="stylesheet" type="text/css" href="js/diaporama/jquery.lightbox-0.5.css"/>
        <link rel="stylesheet" type="text/css" href="js/jquery/captcha/jquery.realperson.css"/>
        
        <link rel="stylesheet" type="text/css" href="js/timepicker/jquery.timepicker.css"/>
        
        <link rel="stylesheet" type="text/css" href="css/video.css">
        <link rel="stylesheet" type="text/css" href="css/site.css">
        
        <%--<link rel="stylesheet" type="text/css" href="css/menu.css">--%>
<!--        
        <link href="css/application.css" rel="stylesheet">
-->
        
        <!-- Modernizr Scripts -->
        <script type="text/javascript" src="js/jquery/jquery-1.10.2.js"></script>
        <script type="text/javascript" src="js/jquery/jquery-ui.js"></script>

        <script type="text/javascript" src="js/grid/flexigrid.js"></script>
        <script type="text/javascript" src="js/graph/jquery.flot.js"></script>
        <script type="text/javascript" src="js/graph/jquery.flot.curvedlines.js"></script>
        
        <script type="text/javascript" src="js/tabs/jquery.easytabs.min.js"></script>
        
        <script type="text/javascript" src="js/jquery/bootstrap.min.js"></script>
        <script type="text/javascript" src="js/jquery/jquery.cookie.js"></script>
        <script type="text/javascript" src="js/diaporama/jquery.lightbox-0.5.js"></script>
        <script type="text/javascript" src="js/jquery/captcha/jquery.realperson.js"></script>
        
        <script type="text/javascript" src="js/timepicker/jquery.timepicker.min.js"></script>
      
        <script type="text/javascript" src="js/dia.main.js"></script> 
        <script type="text/javascript" src="js/dia.jqm.js"></script>
        <script type="text/javascript" src="js/dia.data.js"></script>
        <script type="text/javascript" src="js/dia.menu.js"></script>
        <script type="text/javascript" src="js/dia.aide.js"></script>
        <script type="text/javascript" src="js/dia.config.js"></script>
        <script type="text/javascript" src="js/dia.patient.js"></script>
        <script type="text/javascript" src="js/dia.partage.js"></script>
        <script type="text/javascript" src="js/dia.accueil.js"></script>
        <script type="text/javascript" src="js/dia.connexion.js"></script>
        <script type="text/javascript" src="js/dia.information.js"></script>
        <script type="text/javascript" src="js/dia.inscription.js"></script>
        
        <%
            if(request.getServerName().equals("www.webdia.ch")){
                if (!request.isSecure()){
                    response.sendRedirect("https://www.webdia.ch/diabete/");	
                }
            }
        %>
        <script language="javascript">
            dia.servlet = "<%=request.getContextPath()%>/";
            dia.langue = "${fn:escapeXml(language)}".substring(0,2);
            if((typeof dia.langue === 'undefined') || (dia.langue === null) || (dia.langue != 'fr' && dia.langue != 'de' && dia.langue != 'en')){
                dia.langue = 'fr';
                dia.jqm.setCookie('langue', dia.langue);        
            }
            else {
                dia.langue = dia.langue.substring(0,2);
                dia.jqm.setCookie('langue', dia.langue);
            }
        </script>     
    </head>
    <body>
        <div id="idLoader" class="dvLoading"><fmt:message key="msg.chargement"/></div>
        <!-- Jumbotron -->
        <header class="jumbotron" role="banner">
            <div class="container">
                <div class="menuTop pull-right">
                    <a href="./index.jsp?language=fr"><img src="./ressources/images/flag/francais_down.jpg" id="idLangueFr" width="30" height="18" title="<fmt:message key="langage.francais"/>"></a>
                    <a href="./index.jsp?language=en"><img src="./ressources/images/flag/anglais_down.jpg" id="idLangueEn" width="30" height="18" title="<fmt:message key="langage.anglais"/>"></a>
                    <a href="./index.jsp?language=de"><img src="./ressources/images/flag/allemand_down.jpg" id="idLangueDe" width="30" height="18" title="<fmt:message key="langage.allemand"/>"></a>
                    <!--
                        <a id="idDataPatient" onclick="dia.patient.initLstPatient();"><img src="./ressources/images/application/patient_icon.jpg" height="25" title="<fmt:message key="menu.selectionnerPatient"/>"></a>
                        <a id="idInscription" onclick="dia.main.inscription();"><img src="./ressources/images/connexion/inscription.jpg" height="25" title="<fmt:message key="index.inscription"/>"></a>
                        <a id="idConnexion"><img src="./ressources/images/connexion/connexion.png" height="25" title="<fmt:message key="index.connexion"/>"></a>
                    -->
                </div>
                <div id="idUser" class="menuTop pull-left" style="color:#000088;"></div>
                <div class="row">
                    <div class="col-md-12">
                        <nav id="nav-main" class="navbar navbar-default">
                            <div class="container-fluid">
                                <div class="navbar-header">
                                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#idNavbar" style="width: 45px;">
                                        <span class="icon-bar"></span>
                                        <span class="icon-bar"></span>
                                        <span class="icon-bar"></span>
                                    </button>
                                </div>
                                <div class="collapse navbar-collapse" id="idNavbar">
                                    <ul class="nav navbar-nav">
                                        <li class="active" id="idMenuAccueil"><a onclick="dia.jqm.loadPage('accueil/accueil.jsp');"><fmt:message key="menu.accueil"/></a></li>
                                        <li id="idMenuApplication"><a onclick="dia.jqm.loadPage('application/presentation.jsp');"><fmt:message key="menu.application"/></a></li>
                                        <li id="idMenuConversion"><a onclick="dia.jqm.loadPage('accueil/diabete.jsp');"><fmt:message key="menu.diabete"/></a></li>
<!--                                        <li id="idMenuConversion"><a onclick="dia.jqm.loadPage('application/conversion.jsp');"><fmt:message key="menu.conversion"/></a></li>-->
                                        <li id="idMenuPartenaire"><a onclick="dia.jqm.loadPage('accueil/partenaires.jsp');"><fmt:message key="msg.partenaires"/></a></li>
<!--                                        <li id="idMenuLien"><a onclick="dia.jqm.loadPage('application/lien.jsp');"><fmt:message key="menu.liens"/></a></li>-->
                                        <li id="idMenuAProposDe"><a onclick="dia.jqm.loadPage('accueil/aProposDe.jsp');"><fmt:message key="frm.aProposDe.titre"/></a></li>
<!--                                        <li id="idMenuDonation"><a onclick="dia.jqm.loadPage('accueil/donation.jsp');"><fmt:message key="menu.aide"/></a></li>--->
                                        <li id="idMenuContact"><a onclick="dia.jqm.loadPage('accueil/contact.jsp');"><fmt:message key="menu.contact"/></a></li>
                                    </ul>
                                    <ul class="nav navbar-nav navbar-right">
                                        <div style="margin-top: 12px;">
                                            <a id="idDataPatient" style="display: none" onclick="dia.patient.initLstPatient();"><img src="./ressources/images/application/patient_icon.jpg" height="25" title="<fmt:message key="menu.selectionnerPatient"/>"></a>
                                            <a id="idInscription" onclick="dia.main.inscription();"><img src="./ressources/images/connexion/inscription.jpg" height="25" title="<fmt:message key="index.inscription"/>"></a>
                                            <a id="idConnexion"><img src="./ressources/images/connexion/connexion.png" height="25" title="<fmt:message key="index.connexion"/>"></a>
                                        </div>
                                    </ul>
                                    <ul id="idMenuConnecte" style="display: none" class="nav navbar-nav navbar-inverse">
                                        <li id="idMesDonnees"><a onclick="dia.jqm.loadPage('data/data.jsp');"><fmt:message key="menu.mesDonnees"/></a></li>
                                        <li id="idMaConfiguration"><a onclick="dia.jqm.loadPage('application/configuration.jsp');"><fmt:message key="menu.configuration"/></a></li>
                                        <li id="idChangePassword"><a onclick="dia.jqm.loadPage('accueil/password.jsp');"><fmt:message key="menu.changePassword"/></a></li>
                                        <li id="idInformation"><a onclick="dia.jqm.loadPage('accueil/information.jsp');"><fmt:message key="menu.information"/></a></li>
                                        <li id="idProposerApp"><a onclick="dia.partage.partagerApp();"><fmt:message key="menu.proposerApp"/></a></li>
                                        <li id="idGestionPatient"><a onclick="dia.jqm.loadPage('application/mesPatients.jsp');"><fmt:message key="menu.patient"/></a></li>
                                        <li id="idGestionMedecin"><a onclick="dia.jqm.loadPage('application/mesSoignants.jsp');"><fmt:message key="menu.soignant"/></a></li>
                                    </ul>
                                </div>
                            </div>
                        </nav>
                    </div>
                </div>
                <br>
                <div class="row">
                    <div id="tabContainer"></div>                    
                </div> <!-- /.row -->
            </div>
        </header> <!-- /.jumbotron -->
        
        <!-- Site footer -->
        <div class="jumbotron" id="footer">
            <div class="row">
                <div class="col-xs-6 col-sm-3">
                    <div class="footer-column">
                        <h4><a onclick="dia.jqm.loadPage('accueil/contact.jsp');"><fmt:message key="menu.contact"/></a></h4>
                    </div>                
                </div>
                <div class="col-xs-6 col-sm-3">
                    <div class="footer-column">
                        <h4><a onclick="dia.jqm.loadPage('accueil/partenaires.jsp');"><fmt:message key="msg.partenaires"/></a></h4>
                    </div>                    
                </div>
                <div class="col-xs-6 col-sm-3">
                    <div class="footer-column">
                        <h4><a onclick="dia.jqm.loadPage('application/lien.jsp');"><fmt:message key="menu.liens"/></a></h4>
                    </div>                    
                </div>
                <div class="col-xs-6 col-sm-3">
                    <div class="footer-column">
                        <h4><a onclick="dia.jqm.loadPage('application/conversion.jsp');"><fmt:message key="menu.conversion"/></a></h4>
                    </div>                    
                </div>
            </div>
            <div class="row">
                <div class="footer">
                    <div style="margin-top:5px">- &copy; 2013 - kmKoncept -</div>
                </div>
            </div>
        </div>            
    </body>
</html>

<jsp:include page="/accueil/login.jsp"/> 
<jsp:include page="/accueil/inscription.jsp"/> 

<jsp:include page="/layout/message.jsp"/>
<jsp:include page="/layout/news.jsp"/>

<jsp:include page="international/international.jsp"/>

<div id="idDialogSelectPatient" style="visibility: hidden" title=<fmt:message key="menu.selectionPatient"/>>
    <div class="control-group" style="text-align: center">
        <label class="control-label"><fmt:message key="menu.selectionnerPatient"/></label>
        <div class="controls">
            <div class="input-prepend">
                <select id="idSelectPatient"></select>
            </div>
        </div>
    </div>
</div>

<div id="idDialogSupprimerData" style="display:none" title="<fmt:message key="msg.supprimer"/>">    
    <span><fmt:message key="msg.supprimerDonnees"/></span>
</div>
