<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>

<c:set var="language" value="${not empty param.language ? param.language : not empty language ? language : pageContext.request.locale}" scope="session" />
<fmt:setLocale value="${language}" />
<fmt:setBundle basename="messages/messages"/>


<script type="text/javascript">
    $().ready(function() {
        dia.main.initPresentation( );
    });
</script>

<div class="presentation block text-left">
    <br>
    <h2><fmt:message key="frm.application.titre"/></h2>
    <div class="row">
        <div class="col-md-10 col-md-offset-1 text-right">
            <a href="ressources/webdia.pdf" target="_blank"><img src="ressources/images/layout/pdf.png" title="documentation"><fmt:message key="frm.application.aide.mobile"/></a>
        </div>
    </div>
    <hr class="hr_dashed">
    <div class="row">        
        <div class="col-md-10 col-md-offset-1 text-left">
            <fmt:message key="frm.application.description"/>
        </div>        
    </div>
<!--        
    <div class="row">
        <div class="col-md-9 text-left" style="margin: 20px;">
            <fmt:message key="frm.application.description"/>
        </div>
        <div class="col-md-2">
            <img src="ressources/images/application/famille.jpg" title="famille" />
        </div>        
    </div>
-->
    <hr>
    <h2><fmt:message key="frm.application.raccourci"/></h2>
    <hr class="hr_dashed">
    <div class="row">        
        <div class="col-md-12">
            <img src="ressources/images/raccourciApple.png" title="raccourci" width="100%"/>
        </div>        
    </div>
    <hr>
    <div class="row">
        <div class="col-md-5 text-left" style="margin: 20px;">
            <h2><fmt:message key="frm.application.aide.titre"/></h2>
            <div class="row text-center">
                <table style="width: 90%">
                    <tr>
                        <td><fmt:message key="frm.application.aide.selection"/></td>
                        <td>
                            <select id="idSelectVideo" class="form-control" onchange="dia.aide.video(this.value);">
                                <option value=0><fmt:message key="frm.application.aide.inscription"/></option>
                                <option value=1><fmt:message key="frm.application.aide.configuration"/></option>
                                <option value=2><fmt:message key="frm.application.aide.donnees"/></option>
                                <option value=3><fmt:message key="frm.application.aide.bolus"/></option>
                                <option value=4><fmt:message key="frm.application.aide.aliment"/></option>
                                <option value=5><fmt:message key="frm.application.aide.dureAction"/></option>
                                <option value=6><fmt:message key="frm.application.aide.favoris"/></option>
                            </select>
                        </td>
                    </tr>
                    <tr><td>&nbsp;</td></tr>
                    <tr>
                        <td colspan="2">
                            <iframe id="player" width="400" height="640" frameborder="1" allowscriptaccess="always"></iframe>
                        </td>
                    </tr>
                </table>
            </div>        
        </div>
        <div class="col-md-5 text-left" style="margin: 20px;">
            <h3><fmt:message key="frm.application.aide.raccourci"/></h3>
            <hr>
            <div class="row text-center">
                <div class="col-md-5">
                    <a href="ressources/raccApple.pdf" target='_blank'><img src="ressources/images/layout/pdf.png" title="documentation">iPhone/iPad/iPod</a>
                </div>
                <div class="col-md-5">
                    <a href="ressources/raccAndroid.pdf" target='_blank'><img src="ressources/images/layout/pdf.png" title="documentation">Android</a>
                </div>
            </div>
        </div>
        <div class="col-md-5 text-left" style="margin: 20px;">
            <hr>
            <h3><fmt:message key="frm.application.aide.mobile"/></h3>
            <hr>
            <div class="row">
                <div class="col-md-5 text-center">
                    <a href="ressources/webdia.pdf" target="_blank"><img src="ressources/images/layout/pdf.png" title="documentation">WebDia Smartphone</a>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-12 text-right" style="margin: 20px;">
        <jsp:include page="/layout/hautPage.jsp" />
    </div>
</div>
