<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>

<c:set var="language" value="${not empty param.language ? param.language : not empty language ? language : pageContext.request.locale}" scope="session" />
<fmt:setLocale value="${language}" />
<fmt:setBundle basename="messages/messages"/>

<script>
    $().ready(function() {
        dia.patient.initTblMedecin();
    });
</script>

<div class="presentation block text-left">
    <br>
    <h2><fmt:message key="frm.patient.listeSoignant"/></h2>
    <hr>
    <div class="row">
        <div class="col-md-10 col-md-offset-1 form-border">
            <br>
            <table id="idListMesSoignants" class="table">
                <thead>
                    <tr>
                        <th><fmt:message key="frm.inscription.nom"/></th>
                        <th><fmt:message key="frm.inscription.prenom"/></th>
                        <th><fmt:message key="frm.inscription.email"/></th>
                        <th><fmt:message key="frm.medecin.telephone"/></th>
                        <th>!</th>
                    </tr>
                </thead>
                <tbody>                   
                </tbody>
            </table>
            <hr>
            <div class="text-right">
                <button class="btn btn-default" onclick="dia.patient.ajouterSoignant();"><fmt:message key="msg.ajouter"/></button>
            </div>
            <br>
        </div>
    </div>
    <br>    
</div>

<div id="idDialogSaisieSoignant" style="visibility: hidden" title="<fmt:message key="frm.soignant.dialog"/>">
    <div class="row">
        <br>
        <table id="idListAddSoignants" class="table">
            <thead>
                <tr>            
                    <th><fmt:message key="frm.inscription.nom"/></th>
                    <th><fmt:message key="frm.inscription.prenom"/></th>
                    <th><fmt:message key="frm.inscription.email"/></th>
                    <th>!</th>
                </tr>
            </thead>
            <tbody>                   
            </tbody>
        </table>            
    </div>
</div>            
