<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>

<c:set var="language" value="${not empty param.language ? param.language : not empty language ? language : pageContext.request.locale}" scope="session" />
<fmt:setLocale value="${language}" />
<fmt:setBundle basename="messages/messages"/>

<script>
    $().ready(function() {
        dia.patient.initTblPatient();
    });
</script>

<div class="presentation block text-left">
    <br>
    <h2><fmt:message key="frm.patient.listePatient"/></h2>
    <hr>
    <div class="row">
        <div class="col-md-10 col-md-offset-1 form-border">
            <br>
            <table id="idListMesPatients" class="table">
                <thead>
                    <tr>
                        <th><fmt:message key="frm.inscription.nom"/></th>
                        <th><fmt:message key="frm.inscription.prenom"/></th>
                        <th><fmt:message key="frm.inscription.email"/></th>
                        <th>!</th>
                    </tr>
                </thead>
                <tbody>                   
                </tbody>
            </table>
        </div>
    </div>
    <br>
</div>
