<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>

<c:set var="language" value="${not empty param.language ? param.language : not empty language ? language : pageContext.request.locale}" scope="session" />
<fmt:setLocale value="${language}" />
<fmt:setBundle basename="messages/messages"/>

<div class="presentation block text-left">
    <br>
    <h2><fmt:message key="frm.lien.titre"/></h2>
    <hr>
    <div class="row">
        <div class="col-md-10 col-md-offset-1 text-left">
            <table class="table-responsive form-border-light" width="100%">                
                <tr class="hr_dashed_blue">
                    <td width="50%"><a href="http://www.diabete-geneve.ch/h" target="blank"><img src="ressources/images/liens/diabete_suisse.jpg" width="200"/></a><br></td>
<!--                    <td width="50%"><ul><li><fmt:message key="frm.lien.suisseAssociation"/></li></ul></td>-->
                    <td width="50%"><a href="http://www.diabetesgesellschaft.ch/fr/" target="blank">http://www.diabetesuisse.ch</a></td>
                </tr>
                <tr class="hr_dashed_blue">
                    <td width="50%"><a href="http://www.diabete-geneve.ch/h" target="blank"><img src="ressources/images/liens/Logo_Geneve_2015.jpg" width="200"/></a><br></td>
                    <td width="50%"><a href="http://www.diabete-geneve.ch/" target="blank">http://www.diabete-geneve.ch</a></td>
                </tr>
                <tr class="hr_dashed_blue">
                    <td width="50%"><a href="http://www.grped.ch" target="blank"><img src="ressources/images/liens/grped.png" width="200"/></a><br></td>
                    <td width="50%"><a href="http://www.grped.ch" target="blank">http://www.grped.ch</a></td>
                </tr>
                <tr class="hr_dashed_blue">
                    <td width="50%"><a href="http://www.fdse.ch" target="blank"><img src="ressources/images/liens/fdse.png" width="200"/></a><br></td>
                    <td width="50%"><a href="http://www.fdse.ch" target="blank">http://www.fdse.ch</a></td>
                </tr>
                <tr>
                    <td width="50%"><ul><li><fmt:message key="frm.lien.produits"/></li></ul></td>
                    <td width="50%">
                        <table width="100%">
                            <tr><td><a href="http://geneve.asd-shop.ch/" target="blank">http://geneve.asd-shop.ch/</a></td></tr>
                            <tr><td><a href="http://www.diabete-ezy.com/" target="blank">http://www.diabete-ezy.com/</a></td></tr>
                        </table>
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <hr>
    <div class="row">
        <div class="col-md-11 text-left" style="margin: 20px;">
            <h2><a href="http://www.fondationromande-diabete.ch/" target="blank"><img src="ressources/images/liens/fondation.jpg"><fmt:message key="frm.lien.fondationDiabetique"/></a></h2>
            <h3><fmt:message key="frm.lien.descriptionFilm3"/></h3>
            <br><br>
            <div class="js-video widescreen vimeo">
                <iframe src="https://player.vimeo.com/video/119337247" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe> 
            </div>    
        </div>   
        <div class="col-md-11 text-left" style="margin: 20px;">
            <h3><fmt:message key="frm.lien.descriptionFilm1"/></h3>
            <br><br>
            <div class="js-video widescreen vimeo">
                <iframe src="https://player.vimeo.com/video/112037851" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>                
            </div>
        </div>
    </div>
    <hr class="hr_double">
    <div class="row">
        <div class="col-md-11 text-left" style="margin: 20px;">
            <a href="http://www.hug-ge.ch/video/touche-pas-mon-diabete" target="blank"><img src="ressources/images/liens/hug.png"></a><br>
            <h3><fmt:message key="frm.lien.descriptionFilm2"/></h3>
            <br><br>
            <div class="js-video widescreen">
                <iframe  frameborder="0" src="https://www.dailymotion.com/embed/video/xdc5pa"></iframe>
            </div>
        </div>
    </div>
    <div class="col-md-12 text-right" style="margin: 20px;">
        <jsp:include page="/layout/hautPage.jsp" />
    </div>
</div>
