<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>

<c:set var="language" value="${not empty param.language ? param.language : not empty language ? language : pageContext.request.locale}" scope="session" />
<fmt:setLocale value="${language}" />
<fmt:setBundle basename="messages/messages"/>

<script>
    $().ready(function() {
        dia.jqm.conversionUnite();
    });    
</script>
    
<div class="presentation block text-left">
    <br>
    <h2><fmt:message key="frm.conversion.titre"/></h2>
    <hr>
    <div class="row">
        <div class="col-md-12 text-left" style="margin: 20px;">
            <p>
                <fmt:message key="frm.conversion.texte"/>
            </p>
        </div>
    </div>
    <div class="row">        
        <div class="col-md-10 col-md-offset-1 form-border">
            <table class="table text-center" style="width:100%">
                <thead style="background-color:rgba(0,0,0,0.4);">
                    <tr>
                        <th class="text-center" style="width: 30%">mmol/L</th>
                        <th class="text-center" style="width: 30%">mg/dl</th>
                        <th class="text-center" style="width: 30%">g/l</th>
                    </tr>
                </thead>
                <tbody id="idConversion" style="text-align: center">
                </tbody>
            </table>
        </div>
    </div>
    <br>
    <div class="col-md-12 text-right" style="margin: 20px;">
        <jsp:include page="/layout/hautPage.jsp" />
    </div>
</div>
