<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>

<c:set var="language" value="${not empty param.language ? param.language : not empty language ? language : pageContext.request.locale}" scope="session" />
<fmt:setLocale value="${language}" />
<fmt:setBundle basename="messages/messages"/>

<script>
    $().ready(function() {
        $('#idDialogValideConfig').hide();
        var patient=<%=request.getParameter("p")%>;
        dia.config.init(patient);
    });
</script>

<div class="presentation block text-left">
    <br>
    <h2><fmt:message key="frm.config.titre"/></h2>
    <hr>
    <div class="row">
        <div class="col-md-6 col-md-offset-3 form-border">
            <br>
            <table class="table-responsive text-center borderless" style="width:100%;">
                <tr>
                    <td>
                        <fmt:message key="frm.config.unite"/>
                        <input id="idUnite01" type="radio" name="unite" onclick="dia.config.setUniteGlycemie(1)">&nbsp;mmol/l&nbsp;&nbsp;&nbsp;
                        <input id="idUnite02" type="radio" name="unite" onclick="dia.config.setUniteGlycemie(2)">&nbsp;mg/dl&nbsp;&nbsp;&nbsp;
                        <input id="idUnite03" type="radio" name="unite" onclick="dia.config.setUniteGlycemie(3)">&nbsp;g/l&nbsp;&nbsp;&nbsp;
                    </td>
                </tr>
            </table>
            <hr>
            <table class="table-responsive text-center" style="width:100%;">
                <tr>
                    <td style="text-align:left;"><label><fmt:message key="frm.config.valeurRecherche"/></label></td>
                    <td colspan="2"><input id="idValeur" type="text" class="numeric" placeHolder="mmol/l" style="width: 100px;" onblur="dia.jqm.isNumeric(this);dia.jqm.getValeurRecherche(this);"/></td>
                    <td class="valeur"><label id="idValeurUnite">(mmol/l)</label></td>
                </tr>
                <tr>
                    <td style="text-align:left;"><label><fmt:message key="frm.config.unitCorrectionJour"/></label></td>
                    <td colspan="2"><input id="idCorrectionJour" type="text" class="numeric" placeHolder="1u - mmol/l" style="width: 100px;" onblur="dia.jqm.isNumeric(this);dia.jqm.getDoseCorrection(this);"/></td>
                    <td class="valeur"><label id="idCorrectionUniteJour">(mmol/l)</label></td>
                </tr>
                <tr>
                    <td style="text-align:left;"><label><fmt:message key="frm.config.unitCorrectionNuit"/></label></td>
                    <td colspan="2"><input id="idCorrectionNuit" type="text" class="numeric" placeHolder="1u - mmol/l" style="width: 100px;" onblur="dia.jqm.isNumeric(this);dia.jqm.getDoseCorrection(this);"/></td>
                    <td class="valeur"><label id="idCorrectionUniteNuit">(mmol/l)</label></td>
                </tr>
                <tr>
                    <td style="text-align:left;"><label><fmt:message key="frm.config.dureActionInsuline"/></label></td>
                    <td colspan="2"><input id="idDureeAction" type="text" class="numeric" placeHolder="min." style="width: 100px;" onblur="dia.jqm.isInt(this);"/></td>
                    <td class="valeur"><label>(min.)</label></td>
                </tr>
                <tr><td colspan="4"><hr></td></tr>
                <tr>
                    <td>&nbsp;</td>
                    <td colspan="3" style="text-align: center;"><label class="valeur" style="font-size: 1.2em;"><fmt:message key="frm.config.rapportInsuline"/></label></td>
                </tr>
                <tr>
                    <td style="text-align:left;"><label><fmt:message key="msg.petitDejeuner"/></label></td>
                    <td><input id="idUnite1" type="text" class="numeric" placeHolder="X unit&eacute;s" style="width: 100px;" onblur="dia.jqm.isNumeric(this);dia.jqm.getRatioGlycemique(this);"/></td>
                    <td>&nbsp;/&nbsp;</td>
                    <td><input id="idHdc1" type="text" class="numeric" placeHolder="X hdc" style="width: 100px;" onblur="dia.jqm.isNumeric(this);dia.jqm.getRatioGlycemique(this);"/></td>
                </tr>
                <tr>
                    <td style="text-align:left;"><label><fmt:message key="msg.collation10h"/></label></td>
                    <td><input id="idUnite2" type="text" class="numeric" placeHolder="X unit&eacute;s" style="width: 100px;" onblur="dia.jqm.isNumeric(this);dia.jqm.getRatioGlycemique(this);"/></td>
                    <td>&nbsp;/&nbsp;</td>
                    <td><input id="idHdc2" type="text" class="numeric" placeHolder="X hdC" style="width: 100px;" onblur="dia.jqm.isNumeric(this);dia.jqm.getRatioGlycemique(this);"/></td>
                </tr>
                <tr>
                    <td style="text-align:left;"><label><fmt:message key="msg.dejeuner"/></label></td>
                    <td><input id="idUnite3" type="text" class="numeric" placeHolder="X unit&eacute;s" style="width: 100px;" onblur="dia.jqm.isNumeric(this);dia.jqm.getRatioGlycemique(this);"/></td>
                    <td>&nbsp;/&nbsp;</td>
                    <td><input id="idHdc3" type="text" class="numeric" placeHolder="X hdC" style="width: 100px;" onblur="dia.jqm.isNumeric(this);dia.jqm.getRatioGlycemique(this);"/></td>
                </tr>
                <tr>
                    <td style="text-align:left;"><label><fmt:message key="msg.collation16h"/></label></td>
                    <td><input id="idUnite4" type="text" class="numeric" placeHolder="X unit&eacute;s" style="width: 100px;" onblur="dia.jqm.isNumeric(this);dia.jqm.getRatioGlycemique(this);"/></td>
                    <td>&nbsp;/&nbsp;</td>
                    <td><input id="idHdc4" type="text" class="numeric" placeHolder="X hdC" style="width: 100px;" onblur="dia.jqm.isNumeric(this);dia.jqm.getRatioGlycemique(this);"/></td>
                </tr>
                <tr>
                    <td style="text-align:left;"><label><fmt:message key="msg.diner"/></label></td>
                    <td><input id="idUnite5" type="text" class="numeric" placeHolder="X unit&eacute;s" style="width: 100px;" onblur="dia.jqm.isNumeric(this);dia.jqm.getRatioGlycemique(this);"/></td>
                    <td>&nbsp;/&nbsp;</td>
                    <td><input id="idHdc5" type="text" class="numeric" placeHolder="X hdC" style="width: 100px;" onblur="dia.jqm.isNumeric(this);dia.jqm.getRatioGlycemique(this);"/></td>
                </tr>
                <tr>
                    <td style="text-align:left;"><label><fmt:message key="msg.collationSoir"/></label></td>
                    <td><input id="idUnite6" type="text" class="numeric" placeHolder="X unit&eacute;s" style="width: 100px;" onblur="dia.jqm.isNumeric(this);dia.jqm.getRatioGlycemique(this);"/></td>
                    <td>&nbsp;/&nbsp;</td>
                    <td><input id="idHdc6" type="text" class="numeric" placeHolder="X hdC" style="width: 100px;" onblur="dia.jqm.isNumeric(this);dia.jqm.getRatioGlycemique(this);"/></td>
                </tr>
                <tr>
                    <td colspan="4"><hr></td>
                </tr>
                <tr>
                    <td align="right" colspan="4">
                        <button class="btn btn-default" onclick="dia.config.setDataProfil(<%=request.getParameter("p")%>);">Ok</button>
                    </td>
                </tr>
            </table>
            <br>
        </div>
    </div>
    <br>
</div>

<div id="idDialogValideConfig" style="visibility: hidden" title='<fmt:message key="frm.config.check.titre"/>'>
    <table style="width: 100%">
        <tr><td colspan="2"><hr></td></tr>
        <tr><td colspan="2" style="text-align: center"><label style="font-size: 1.2em" id="idValideConfigInfo"></label></td></tr>
        <tr><td colspan="2"><hr></td></tr>
        <tr>
            <td style="text-align:left;width:180px;"><label><fmt:message key="frm.config.unite"/></label></td>
            <td><label id="idDialogValideConfigUnite"></label></td>
        </tr>
        <tr>
            <td style="text-align:left;width:180px;"><label id="idLabelValeur"><fmt:message key="frm.config.valeurRecherche"/></label></td>
            <td><label id="idDialogValideConfigValeur"></label></td>
        </tr>
        <tr>
            <td style="text-align:left;width:180px;"><label id="idLabelCorrectionJour"><fmt:message key="frm.config.unitCorrectionJour"/></label></td>
            <td><label id="idDialogValideConfigCJ"></label></td>
        </tr>
        <tr>
            <td style="text-align:left;width:180px;"><label id="idLabelCorrectionNuit"><fmt:message key="frm.config.unitCorrectionNuit"/></label></td>
            <td><label id="idDialogValideConfigCN"></label></td>
        </tr>
        <tr>
            <td style="text-align:left;width:180px;"><label><fmt:message key="frm.config.dureActionInsuline"/></label></td>
            <td><label id="idDialogValideConfigDI"></label></td>
        </tr>
        <tr><td colspan="3"><hr></td></tr>
        <tr>
            <td colspan="2" style="text-align: center;width: 100%"><label class="valeur"><fmt:message key="frm.config.rapportInsuline"/></label></td>
        </tr>
        <tr>
            <td style="text-align:left;width:180px;"><label><fmt:message key="msg.petitDejeuner"/></label></td>
            <td><label id="idDialogValideConfigU1"></label></td>
        </tr>
        <tr>
            <td style="text-align:left;width:180px;"><label><fmt:message key="msg.collation10h"/></label></td>
            <td><label id="idDialogValideConfigU2"></label></td>
        </tr>
        <tr>
            <td style="text-align:left;width:180px;"><label><fmt:message key="msg.dejeuner"/></label></td>
            <td><label id="idDialogValideConfigU3"></label></td>
        </tr>
        <tr>
            <td style="text-align:left;width:180px;"><label><fmt:message key="msg.collation16h"/></label></td>
            <td><label id="idDialogValideConfigU4"></label></td>
        </tr>
        <tr>
            <td style="text-align:left;width:180px;"><label><fmt:message key="msg.diner"/></label></td>
            <td><label id="idDialogValideConfigU5"></label></td>
        </tr>
        <tr>
            <td style="text-align:left;width:180px;"><label ><fmt:message key="msg.collationSoir"/></label></td>
            <td><label id="idDialogValideConfigU6"></label></td>
        </tr>
        <tr><td colspan="2"><hr></td></tr>
        <tr><td colspan="2" style="font-size: 1.2em"><fmt:message key="frm.config.check.validation"/></td></tr>
        <tr><td colspan="2"><hr></td></tr>
    </table>
</div>
