<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>

<c:set var="language" value="${not empty param.language ? param.language : not empty language ? language : pageContext.request.locale}" scope="session" />
<fmt:setLocale value="${language}" />
<fmt:setBundle basename="messages/messages"/>

<script>
    $().ready(function() {
    });
</script>

<div class="presentation block text-left">
    <br>
    <h2><fmt:message key="frm.password.titre"/></h2>
    <hr>
    <div class="row">
        <div class="col-md-6 col-md-offset-3 form-border">
            <br>
            <div class="form-group">
                <label class="control-label"><fmt:message key="frm.password.ancienMotdepasse"/></label>
                <input class="form-control" type="password" name="oldPassword" value="" required>
            </div>
            <div class="control-group">
                <label class="control-label"><fmt:message key="frm.password.nouveauMotdepasse"/></label>
                <input class="form-control" type="password" name="password1" required value="">
                <br>
            </div>
            <div class="control-group">
                <label class="control-label"><fmt:message key="frm.password.reNouveauMotdepasse"/></label>
                <input class="form-control" type="password" name="password2" required value="">
            </div>
            <hr>
            <div class="text-right">
                <button class="btn btn-default" onclick="dia.inscription.initChangePassword();">Ok</button>
            </div>
            <br>
        </div>
    </div>
    <br>
</div>
