<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>

<c:set var="language" value="${not empty param.language ? param.language : not empty language ? language : pageContext.request.locale}" scope="session" />
<fmt:setLocale value="${language}" />
<fmt:setBundle basename="messages/messages"/>

<script>
    $().ready(function() {
        dia.partage.init( );
    });
</script>

<div class="presentation block text-left">
    <br>
    <h2><fmt:message key="frm.partage.titre"/></h2>
    <hr>
<!--    
    <div class="row">
        <div style="text-align: center;">
            <h2>
                <fmt:message key="frm.partage.confrere"/>
                <a href='mailto:?Subject=WEBDIA&body=<fmt:message key="mailto.body"/>'><img src="ressources/images/liens/share.png" width="40" title="<fmt:message key="frm.accueil.partager"/>"/></a>
            </h2>
        </div>
    </div>
-->
    <div class="row">
        <div class="col-md-8 col-md-offset-2 form-border">
            <div style="text-align: left;margin-top: 10px">
                <fmt:message key="frm.partage.patient"/>                           
            </div>
            <hr>
            <div class="control-group">
                <label class="control-label"><fmt:message key="frm.inscription.genre"/></label>
                <div class="controls" style="color:#555">
                    <select name="politessePartage">
                        <option value="1"><fmt:message key="frm.inscription.monsieur"/></option>
                        <option value="2"><fmt:message key="frm.inscription.madame"/></option>
                    </select>
                </div>
                <br>
            </div>
            <div class="control-group">
                <label class="control-label"><fmt:message key="frm.inscription.nom"/></label>
                <div class="controls">
                    <div class="input-prepend">
                        <span class="add-on"><i class="icon-user"></i></span>
                        <input type="text" class="form-control" name="nomPartage" placeholder="<fmt:message key="frm.inscription.nom"/>">
                    </div>
                </div>
                <br>
            </div>
            <div class="control-group ">
                <label class="control-label"><fmt:message key="frm.inscription.prenom"/></label>
                <div class="controls">
                    <div class="input-prepend">
                        <span class="add-on"><i class="icon-user"></i></span>
                        <input type="text" class="form-control" name="prenomPartage" placeholder="<fmt:message key="frm.inscription.prenom"/>">
                    </div>
                </div>
                <br>
            </div>
            <div class="control-group">
                <label class="control-label"><fmt:message key="frm.inscription.email"/></label>
                <div class="controls">
                    <div class="input-prepend">
                        <span class="add-on"><i class="icon-envelope"></i></span>
                        <input type="text" class="form-control" name="emailPartage" onblur="dia.jqm.isValidEmailAddress($(this).val())" placeholder="<fmt:message key="frm.inscription.email"/>">
                    </div>
                </div>
                <br>
            </div>
<!--                    
            <div class="control-group ">
                <label class="control-label"><fmt:message key="frm.contact.message"/></label>
                <div class="controls">
                    <div class="input-prepend">
                        <span class="add-on"><i class="icon-user"></i></span>
                        <textarea name="messagePartage" rows="4" class="form-control" placeholder="<fmt:message key="frm.contact.message"/>"></textarea>
                    </div>
                </div>
                <br>
            </div>
-->
            <div class="control-group text-center">
                <label class="control-label"><fmt:message key="frm.inscription.code"/></label>
                <div class="controls">
                    <span id="idPartageCodeCaptcha"/>
                    <input name="partageCode" value="" required size="20">
                </div>
                <br>
            </div>
            <hr>
            <div class="text-right">
                <button class="btn btn-default" onclick="dia.partage.validationAddPatient();"><fmt:message key="frm.contact.envoyer"/></button>
            </div>
            <br>
        </div>
    </div>
    <br>
    <br>
</div>
