<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>

<c:set var="language" value="${not empty param.language ? param.language : not empty language ? language : pageContext.request.locale}" scope="session" />
<fmt:setLocale value="${language}" />
<fmt:setBundle basename="messages/messages"/>

<script>
    $().ready(function() {
        dia.inscription.initContact();
    });
</script>

<div class="presentation block text-left">
    <br>
    <h2><fmt:message key="frm.contact.titre"/></h2>
    <hr>
    <div class="row">
        <div class="col-md-6 col-md-offset-3 form-border">
            <br>
            <div class="form-group">
                <label class="control-label" for="idMail"><fmt:message key="frm.inscription.email"/></label>
                <input id="idMail" class="form-control" value="" onblur="dia.jqm.isValidEmailAddress($(this).val())">
            </div>
            <div class="control-group">
                <label class="control-label" for="idSujet"><fmt:message key="frm.contact.sujet"/></label>
                <input id="idSujet" class="form-control" value="" >
                <br>
            </div>
            <div class="control-group">
                <label class="control-label" for="idMessage"><fmt:message key="frm.contact.message"/></label>
                <textarea id="idMessage" rows="4" class="form-control"></textarea>
            </div>
            <br>
            <div class="control-group text-center">
                <label class="control-label" for="idCode"><fmt:message key="frm.inscription.code"/></label>
                <span id="idCodeContactCaptcha"></span>
                <input id="idCode" class="form-group-sm" name="code" value="">
            </div>
            <hr>
            <div class="text-right">
                <button id="idSubmitContact" class="btn btn-default"><fmt:message key="frm.contact.envoyer"/></button>
            </div>
            <br>
        </div>
    </div>
    <br>
</div>