<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>

<c:set var="language" value="${not empty param.language ? param.language : not empty language ? language : pageContext.request.locale}" scope="session" />
<fmt:setLocale value="${language}" />
<fmt:setBundle basename="messages/messages"/>

<script>
    $().ready(function() {
        dia.accueil.init();
    });
</script>

<div class="col-sm-6 col-md-8 col-lg-7">                        
    <div class="presentation block">
        <div>
            <!-- Logo -->
            <figure class="text-center">
                <a href="./index.jsp"><img class="img-logo" src="ressources/images/logo_webdia.png" alt=""></a>
            </figure> <!-- /.text-center -->

            <!-- Title -->
            <h1><fmt:message key="site.title"/></h1>
            <!-- Sub title -->
            <div class="text-left" style="margin: 20px;">
                <p><fmt:message key="site.invite"/></p>
            </div>

            <!-- Button -->
            <div class="btn-app-store">
                <div class="row">
                    <div class="col-xs-6 col-sm-6">
                        <a href="https://play.google.com/store/apps/details?id=ch.kmconcept.webdia2" target="blank"><img src="ressources/images/google_play.png" alt="WebDia googlePlay" height="100"></a>
                    </div>
                    <div class="col-xs-6 col-sm-6">
                        <a href="https://itunes.apple.com/fr/app/webdia-hug/id1050648647?mt=8" target="blank"><img id="idImageAppIPhone" src="./ressources/images/apple_store_fr.png" alt="WebDia appleStore" height="100"/></a>
                    </div> 
<!--                    
                    <div class="col-xs-4 col-sm-4">
                        <a onclick="dia.jqm.loadPage('application/presentation.jsp');"><img src="./ressources/images/webapp.png" width="100" /></a>
                    </div>    
-->
<!--
                    <a onclick="dia.jqm.loadPage('accueil/donation.jsp');" title="<fmt:message key="menu.aide"/>" alt="<fmt:message key="menu.aide"/>"><img src="./ressources/images/application/help2.jpg" width="120" /></a>
                    <a onclick="dia.jqm.loadPage('accueil/donation.jsp');"><fmt:message key="menu.aide"/></a>
-->
                </div>
                <div class="row">
                    <hr class="hr_dashed">
                </div>
                <div class="row">
                    <fmt:message key="msg.accueilProposerApp"/>&nbsp;<a href='mailto:?Subject=WEBDIA&body=<fmt:message key="mailto.body"/>'><img src="ressources/images/liens/share.png" width="40" title="<fmt:message key="frm.accueil.partager"/>"/></a>
                </div>
                <br>
            </div> <!-- /.btn-app-store -->
        </div>
    </div>
</div> <!-- /.col-md-8 -->
<div class="col-sm-6 col-md-4 col-lg-5">
    <!-- Images showcase -->
    <img id="idImageMobileApp" class="img-iPhone" src="" alt="WEBDIA mobile" style="max-width: 100%">
<!--        
    <figure>      
        <img class="img-iPhone" src="ressources/images/iphone.png" alt="WEBDIA mobile">
    </figure>
-->
<!--    
    <div class="col-sm-2">
        <div class="fb-like" data-share="true" data-width="450" data-show-faces="true"></div>        
    </div>
-->
</div> <!-- /.col-md-5 -->
