/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BuiltIn;
import freemarker.core.Environment;
import freemarker.core.EvalUtil;
import freemarker.core.Expression;
import freemarker.core.Macro;
import freemarker.core.MessageUtil;
import freemarker.core.UnexpectedTypeException;
import freemarker.core._DelayedJQuote;
import freemarker.core._ErrorDescriptionBuilder;
import freemarker.core._MiscTemplateException;
import freemarker.core._TemplateModelException;
import freemarker.ext.beans.BeanModel;
import freemarker.ext.beans._BeansAPI;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.TemplateTransformModel;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

class MiscellaneousBuiltins {
    private MiscellaneousBuiltins() {
    }

    static class cBI
    extends BuiltIn {
        cBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel model = this.target.eval(env);
            if (model instanceof TemplateNumberModel) {
                Number num = EvalUtil.modelToNumber((TemplateNumberModel)model, this.target);
                if (num instanceof Integer || num instanceof Long) {
                    return new SimpleScalar(num.toString());
                }
                return new SimpleScalar(env.getCNumberFormat().format(num));
            }
            if (model instanceof TemplateBooleanModel) {
                return new SimpleScalar(((TemplateBooleanModel)model).getAsBoolean() ? "true" : "false");
            }
            throw new UnexpectedTypeException(this.target, model, "number or boolean", env);
        }
    }

    static class namespaceBI
    extends BuiltIn {
        namespaceBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            if (!(tm instanceof Macro)) {
                throw new UnexpectedTypeException(this.target, tm, "macro or function", env);
            }
            return env.getMacroNamespace((Macro)tm);
        }
    }

    static class is_directiveBI
    extends BuiltIn {
        is_directiveBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateTransformModel || tm instanceof Macro || tm instanceof TemplateDirectiveModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_enumerableBI
    extends BuiltIn {
        is_enumerableBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateSequenceModel || tm instanceof TemplateCollectionModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_indexableBI
    extends BuiltIn {
        is_indexableBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateSequenceModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_collectionBI
    extends BuiltIn {
        is_collectionBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateCollectionModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_sequenceBI
    extends BuiltIn {
        is_sequenceBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateSequenceModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_hash_exBI
    extends BuiltIn {
        is_hash_exBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateHashModelEx ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_hashBI
    extends BuiltIn {
        is_hashBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateHashModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_transformBI
    extends BuiltIn {
        is_transformBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateTransformModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_macroBI
    extends BuiltIn {
        is_macroBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof Macro ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_methodBI
    extends BuiltIn {
        is_methodBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateMethodModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_dateBI
    extends BuiltIn {
        is_dateBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateDateModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_booleanBI
    extends BuiltIn {
        is_booleanBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateBooleanModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_nodeBI
    extends BuiltIn {
        is_nodeBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateNodeModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_numberBI
    extends BuiltIn {
        is_numberBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateNumberModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_stringBI
    extends BuiltIn {
        is_stringBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel tm = this.target.eval(env);
            this.target.assertNonNull(tm, env);
            return tm instanceof TemplateScalarModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class stringBI
    extends BuiltIn {
        stringBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel model = this.target.eval(env);
            if (model instanceof TemplateNumberModel) {
                return new NumberFormatter(EvalUtil.modelToNumber((TemplateNumberModel)model, this.target), env);
            }
            if (model instanceof TemplateDateModel) {
                TemplateDateModel dm = (TemplateDateModel)model;
                int dateType = dm.getDateType();
                return new DateFormatter(EvalUtil.modelToDate(dm, this.target), dateType, env);
            }
            if (model instanceof SimpleScalar) {
                return model;
            }
            if (model instanceof TemplateBooleanModel) {
                return new BooleanFormatter((TemplateBooleanModel)model, env);
            }
            if (model instanceof TemplateScalarModel) {
                return new SimpleScalar(((TemplateScalarModel)model).getAsString());
            }
            if (env.isClassicCompatible() && model instanceof BeanModel) {
                return new SimpleScalar(_BeansAPI.getAsClassicCompatibleString((BeanModel)model));
            }
            throw new UnexpectedTypeException(this.target, model, "number, date, or string", env);
        }

        private class BooleanFormatter
        implements TemplateScalarModel,
        TemplateMethodModel {
            private final TemplateBooleanModel bool;
            private final Environment env;

            BooleanFormatter(TemplateBooleanModel bool, Environment env) {
                this.bool = bool;
                this.env = env;
            }

            public String getAsString() throws TemplateModelException {
                if (this.bool instanceof TemplateScalarModel) {
                    return ((TemplateScalarModel)((Object)this.bool)).getAsString();
                }
                try {
                    return this.env.formatBoolean(this.bool.getAsBoolean(), true);
                }
                catch (TemplateException e) {
                    throw new TemplateModelException(e);
                }
            }

            public Object exec(List args) throws TemplateModelException {
                stringBI.this.checkMethodArgCount(args, 2);
                return new SimpleScalar((String)args.get(this.bool.getAsBoolean() ? 0 : 1));
            }
        }

        private class DateFormatter
        implements TemplateScalarModel,
        TemplateHashModel,
        TemplateMethodModel {
            private final Date date;
            private final int dateType;
            private final Environment env;
            private final DateFormat defaultFormat;
            private String cachedValue;

            DateFormatter(Date date, int dateType, Environment env) throws TemplateModelException {
                this.date = date;
                this.dateType = dateType;
                this.env = env;
                this.defaultFormat = env.getDateFormatObject(dateType);
            }

            public String getAsString() throws TemplateModelException {
                if (this.dateType == 0) {
                    throw new _TemplateModelException(new _ErrorDescriptionBuilder("Can't convert the date to string, because it isn't known if it's a date-only, time-only, or date-time value.").tip(MessageUtil.UNKNOWN_DATE_TO_STRING_TIPS));
                }
                if (this.cachedValue == null) {
                    this.cachedValue = this.defaultFormat.format(this.date);
                }
                return this.cachedValue;
            }

            public TemplateModel get(String key) throws TemplateModelException {
                return new SimpleScalar(this.env.getDateFormatObject(this.dateType, key).format(this.date));
            }

            public Object exec(List args) throws TemplateModelException {
                stringBI.this.checkMethodArgCount(args, 1);
                return this.get((String)args.get(0));
            }

            public boolean isEmpty() {
                return false;
            }
        }

        private class NumberFormatter
        implements TemplateScalarModel,
        TemplateHashModel,
        TemplateMethodModel {
            private final Number number;
            private final Environment env;
            private final NumberFormat defaultFormat;
            private String cachedValue;

            NumberFormatter(Number number, Environment env) {
                this.number = number;
                this.env = env;
                this.defaultFormat = env.getNumberFormatObject(env.getNumberFormat());
            }

            public String getAsString() {
                if (this.cachedValue == null) {
                    this.cachedValue = this.defaultFormat.format(this.number);
                }
                return this.cachedValue;
            }

            public TemplateModel get(String key) {
                return new SimpleScalar(this.env.getNumberFormatObject(key).format(this.number));
            }

            public Object exec(List args) throws TemplateModelException {
                stringBI.this.checkMethodArgCount(args, 1);
                return this.get((String)args.get(0));
            }

            public boolean isEmpty() {
                return false;
            }
        }
    }

    static class dateBI
    extends BuiltIn {
        private final int dateType;

        dateBI(int dateType) {
            this.dateType = dateType;
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel model = this.target.eval(env);
            if (model instanceof TemplateDateModel) {
                TemplateDateModel dmodel = (TemplateDateModel)model;
                int dtype = dmodel.getDateType();
                if (this.dateType == dtype) {
                    return model;
                }
                if (dtype == 0 || dtype == 3) {
                    return new SimpleDate(dmodel.getAsDate(), this.dateType);
                }
                throw new _MiscTemplateException((Expression)this, new Object[]{"Cannot convert ", TemplateDateModel.TYPE_NAMES.get(dtype), " into ", TemplateDateModel.TYPE_NAMES.get(this.dateType)});
            }
            String s = this.target.evalAndCoerceToString(env);
            return new DateParser(s, env);
        }

        private class DateParser
        implements TemplateDateModel,
        TemplateMethodModel,
        TemplateHashModel {
            private final String text;
            private final Environment env;
            private final DateFormat defaultFormat;
            private Date cachedValue;

            DateParser(String text, Environment env) throws TemplateModelException {
                this.text = text;
                this.env = env;
                this.defaultFormat = env.getDateFormatObject(dateBI.this.dateType);
            }

            public Date getAsDate() throws TemplateModelException {
                if (this.cachedValue == null) {
                    this.cachedValue = this.parse(this.defaultFormat);
                }
                return this.cachedValue;
            }

            public int getDateType() {
                return dateBI.this.dateType;
            }

            public TemplateModel get(String pattern) throws TemplateModelException {
                return new SimpleDate(this.parse(this.env.getDateFormatObject(dateBI.this.dateType, pattern)), dateBI.this.dateType);
            }

            public Object exec(List args) throws TemplateModelException {
                dateBI.this.checkMethodArgCount(args, 1);
                return this.get((String)args.get(0));
            }

            public boolean isEmpty() {
                return false;
            }

            private Date parse(DateFormat df) throws TemplateModelException {
                try {
                    return df.parse(this.text);
                }
                catch (ParseException e) {
                    String pattern = null;
                    if (df instanceof SimpleDateFormat) {
                        pattern = ((SimpleDateFormat)df).toPattern();
                    }
                    throw new _TemplateModelException(new Object[]{"The string doesn't match the expected date/time format. The string to parse was: ", new _DelayedJQuote(this.text), ". ", pattern != null ? "The expected format was: " : "", pattern != null ? new _DelayedJQuote(pattern) : "", pattern != null ? ". " : ""});
                }
            }
        }
    }

    static class sizeBI
    extends BuiltIn {
        sizeBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel model = this.target.eval(env);
            if (model instanceof TemplateSequenceModel) {
                int size = ((TemplateSequenceModel)model).size();
                return new SimpleNumber(size);
            }
            if (model instanceof TemplateHashModelEx) {
                int size = ((TemplateHashModelEx)model).size();
                return new SimpleNumber(size);
            }
            throw new UnexpectedTypeException(this.target, model, "extended-hash or sequence", env);
        }
    }
}

