/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.AssignmentInstruction;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.InvalidReferenceException;
import freemarker.core.ParameterRole;
import freemarker.core.TemplateElement;
import freemarker.core.UnexpectedTypeException;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateScalarModel;

final class Assignment
extends TemplateElement {
    private String variableName;
    private Expression value;
    private Expression namespaceExp;
    private int scope;
    static final int NAMESPACE = 1;
    static final int LOCAL = 2;
    static final int GLOBAL = 3;

    Assignment(String variableName, Expression value, int scope) {
        this.variableName = variableName;
        this.value = value;
        this.scope = scope;
    }

    void setNamespaceExp(Expression namespaceExp) {
        this.namespaceExp = namespaceExp;
    }

    void accept(Environment env) throws TemplateException {
        TemplateModel tm;
        Environment.Namespace namespace = null;
        if (this.namespaceExp != null) {
            TemplateModel namespaceTM = this.namespaceExp.eval(env);
            try {
                namespace = (Environment.Namespace)namespaceTM;
            }
            catch (ClassCastException e) {
                throw new UnexpectedTypeException(this.namespaceExp, namespaceTM, "namespace", env);
            }
            if (namespace == null) {
                throw InvalidReferenceException.getInstance(this.namespaceExp, env);
            }
        }
        if ((tm = this.value.eval(env)) == null) {
            if (env.isClassicCompatible()) {
                tm = TemplateScalarModel.EMPTY_STRING;
            } else {
                throw InvalidReferenceException.getInstance(this.value, env);
            }
        }
        if (this.scope == 2) {
            env.setLocalVariable(this.variableName, tm);
        } else {
            if (namespace == null) {
                if (this.scope == 3) {
                    namespace = env.getGlobalNamespace();
                } else if (this.scope == 1) {
                    namespace = env.getCurrentNamespace();
                } else {
                    throw new RuntimeException("Unexpected scope type: " + this.scope);
                }
            }
            namespace.put(this.variableName, tm);
        }
    }

    protected String dump(boolean canonical) {
        String dn;
        StringBuffer buf = new StringBuffer();
        String string = dn = this.parent instanceof AssignmentInstruction ? null : this.getNodeTypeSymbol();
        if (dn != null) {
            if (canonical) {
                buf.append("<");
            }
            buf.append(dn);
            buf.append(' ');
        }
        buf.append(this.variableName);
        buf.append(" = ");
        buf.append(this.value.getCanonicalForm());
        if (dn != null) {
            if (this.namespaceExp != null) {
                buf.append(" in ");
                buf.append(this.namespaceExp.getCanonicalForm());
            }
            if (canonical) {
                buf.append(">");
            }
        }
        String result = buf.toString();
        return result;
    }

    String getNodeTypeSymbol() {
        return Assignment.getDirectiveName(this.scope);
    }

    static String getDirectiveName(int scope) {
        if (scope == 2) {
            return "#local";
        }
        if (scope == 3) {
            return "#global";
        }
        if (scope == 1) {
            return "#assign";
        }
        return "#{unknown_assignment_type}";
    }

    int getParameterCount() {
        return 4;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.variableName;
            }
            case 1: {
                return this.value;
            }
            case 2: {
                return new Integer(this.scope);
            }
            case 3: {
                return this.namespaceExp;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.ASSIGNMENT_TARGET;
            }
            case 1: {
                return ParameterRole.ASSIGNMENT_SOURCE;
            }
            case 2: {
                return ParameterRole.VARIABLE_SCOPE;
            }
            case 3: {
                return ParameterRole.NAMESPACE;
            }
        }
        throw new IndexOutOfBoundsException();
    }
}

