/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.web.servlets.serializer;

import ch.dia.model.DiaMedecin;
import ch.dia.model.DiaUtilisateur;
import ch.dia.utils.utString;
import ch.dia.web.servlets.serializer.AbstractSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.apache.commons.lang.StringEscapeUtils;

public class InformationSerializer
extends AbstractSerializer
implements JsonSerializer<DiaUtilisateur> {
    public JsonElement serialize(DiaUtilisateur utilisateur, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject retValue = new JsonObject();
        retValue.addProperty("id", StringEscapeUtils.unescapeJava((String)utilisateur.getEmail()));
        retValue.addProperty("typeAcces", (Number)this.getTypeAccess(utilisateur));
        retValue.addProperty("sexe", (Number)utilisateur.getSexe());
        retValue.addProperty("nom", StringEscapeUtils.unescapeJava((String)utilisateur.getNom()));
        retValue.addProperty("prenom", StringEscapeUtils.unescapeJava((String)utilisateur.getPrenom()));
        if (utilisateur instanceof DiaMedecin) {
            DiaMedecin medecin = (DiaMedecin)utilisateur;
            retValue.addProperty("medecin_tel", StringEscapeUtils.unescapeJava((String)medecin.getTel()));
            retValue.addProperty("medecin_adresse", StringEscapeUtils.unescapeJava((String)medecin.getAdresse()));
            retValue.addProperty("medecin_cp", StringEscapeUtils.unescapeJava((String)medecin.getCp()));
            retValue.addProperty("medecin_ville", StringEscapeUtils.unescapeJava((String)medecin.getVille()));
            retValue.addProperty("medecin_pays", StringEscapeUtils.unescapeJava((String)medecin.getPays()));
            retValue.addProperty("medecin_visible", utString.stringNotNull(medecin.getVisible()));
        }
        return retValue;
    }
}

