/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.web.servlets.filter;

import ch.dia.web.servlets.components.DiaCookieHandler;
import com.google.common.cache.Cache;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class ValidTokenFilter
implements Filter {
    DiaCookieHandler cookieHandler = new DiaCookieHandler();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean shouldInitiateTx;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String method = httpRequest.getMethod();
        boolean bPost = method.equalsIgnoreCase("POST");
        boolean bPut = method.equalsIgnoreCase("PUT");
        boolean bDelete = method.equalsIgnoreCase("DELETE");
        boolean bl = shouldInitiateTx = bPost || bPut || bDelete;
        if (shouldInitiateTx) {
            Cache csrfPreventionTokenCache;
            String token = StringEscapeUtils.escapeJava((String)request.getParameter("t"));
            if (token != null) {
                Document doc = Jsoup.parse((String)token);
                token = doc.text();
            }
            if ((csrfPreventionTokenCache = (Cache)httpRequest.getSession().getAttribute("TOKEN")) != null && token != null && csrfPreventionTokenCache.getIfPresent((Object)token) != null) {
                csrfPreventionTokenCache.invalidate((Object)token);
                chain.doFilter(request, response);
            } else {
                httpResponse.sendError(403, "Potential CSRF detected!");
            }
        } else {
            chain.doFilter(request, response);
        }
    }
}

