/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.web.servlets.filter;

import java.io.IOException;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionFilter
implements Filter {
    public static final Logger LOGGER = LoggerFactory.getLogger(TransactionFilter.class);
    private EntityManager entityManager;

    public void init(FilterConfig fc) throws ServletException {
        this.entityManager = (EntityManager)fc.getServletContext().getAttribute(EntityManager.class.getName());
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String method = httpRequest.getMethod();
        boolean bPost = method.equalsIgnoreCase("POST");
        boolean bPut = method.equalsIgnoreCase("PUT");
        boolean bDelete = method.equalsIgnoreCase("DELETE");
        boolean shouldInitiateTx = bPost || bDelete || bPut;
        EntityTransaction tx = this.entityManager.getTransaction();
        try {
            if (shouldInitiateTx && !tx.isActive()) {
                tx.begin();
            }
            filterChain.doFilter(request, response);
            if (shouldInitiateTx && tx.isActive()) {
                tx.commit();
            }
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
        }
    }
}

