/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.web.servlets.filter;

import ch.dia.web.servlets.components.DiaCookieHandler;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.RandomStringUtils;

public class SetTokenFilter
implements Filter {
    DiaCookieHandler cookieHandler = new DiaCookieHandler();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String method = httpRequest.getMethod();
        String uri = httpRequest.getRequestURI();
        Cache csrfPreventionTokenCache = (Cache)httpRequest.getSession().getAttribute("TOKEN");
        if (csrfPreventionTokenCache == null) {
            csrfPreventionTokenCache = CacheBuilder.newBuilder().maximumSize(5000L).expireAfterWrite(20L, TimeUnit.MINUTES).build();
            httpRequest.getSession().setAttribute("TOKEN", (Object)csrfPreventionTokenCache);
        }
        String token = RandomStringUtils.random((int)20, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)new SecureRandom());
        csrfPreventionTokenCache.put((Object)token, (Object)Boolean.TRUE);
        this.cookieHandler.setToken(httpRequest, httpResponse, token);
        chain.doFilter(request, response);
    }
}

