/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.web.servlets.filter;

import ch.dia.exceptions.ServletValidationException;
import ch.dia.utils.ResourceBundleUtils;
import ch.dia.web.servlets.components.DiaCookieHandler;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHandlingFilter
implements Filter {
    public static final Logger LOGGER = LoggerFactory.getLogger(ExceptionHandlingFilter.class);
    DiaCookieHandler cookieHandler;

    public void init(FilterConfig fc) throws ServletException {
        this.cookieHandler = new DiaCookieHandler();
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            filterChain.doFilter(request, response);
        }
        catch (ServletValidationException ex) {
            String lang = this.cookieHandler.getLanguage(httpRequest);
            Locale locale = new Locale.Builder().setLanguage(lang).build();
            LOGGER.error("ServletValidationException trapped during Filter chain", (Throwable)((Object)ex));
            String message = ResourceBundleUtils.getErrorText(ex.getMessageKey(), locale);
            if (ex.getMessage() != null) {
                message = message + " - " + ex.getMessage();
            }
            this.resetResponseAndSendError(httpResponse, ex.getStatus(), message);
        }
        catch (Exception ex) {
            String lang = this.cookieHandler.getLanguage(httpRequest);
            Locale locale = new Locale.Builder().setLanguage(lang).build();
            LOGGER.error("Exception trapped during Filter chain", (Throwable)ex);
            this.resetResponseAndSendError(httpResponse, 500, ResourceBundleUtils.getErrorText("errors.connexion.serveur", locale));
        }
    }

    private void resetResponseAndSendError(HttpServletResponse httpResponse, int status, String message) throws IOException {
        httpResponse.reset();
        httpResponse.sendError(status, message);
    }
}

