/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.web.servlets.filter;

import ch.dia.model.DiaUtilisateur;
import ch.dia.services.SrvConnexion;
import ch.dia.utils.RequestUtils;
import ch.dia.utils.ResourceBundleUtils;
import ch.dia.utils.utString;
import ch.dia.web.servlets.components.DiaCookieHandler;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnexionFilter
implements Filter {
    public static final Logger LOGGER = LoggerFactory.getLogger(ConnexionFilter.class);
    DiaCookieHandler cookieHandler = new DiaCookieHandler();
    SrvConnexion srvConnexion;

    protected <T> T getServiceBean(ServletContext servletContext, Class<T> clazz) {
        return (T)servletContext.getAttribute(clazz.getName());
    }

    public void init(FilterConfig fc) throws ServletException {
        this.srvConnexion = this.getServiceBean(fc.getServletContext(), SrvConnexion.class);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        DiaUtilisateur pUti = this.srvConnexion.getIdShaUtilisateur(utString.stringNotNull(this.cookieHandler.get(httpRequest)));
        if (pUti != null) {
            RequestUtils.setDiaUtilisateur(httpRequest, pUti);
            filterChain.doFilter(request, response);
        } else {
            String lang = this.cookieHandler.getLanguage(httpRequest);
            Locale locale = new Locale.Builder().setLanguage(lang).build();
            httpResponse.sendError(403, ResourceBundleUtils.getErrorText("errors.connexion.serveur", locale));
        }
    }

    public void destroy() {
    }
}

