/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.web.servlets.connectServlet;

import ch.dia.exceptions.ServletValidationException;
import ch.dia.model.DiaMedecin;
import ch.dia.model.DiaUtilisateur;
import ch.dia.services.SrvConnexion;
import ch.dia.services.SrvInformation;
import ch.dia.utils.utSha1;
import ch.dia.utils.utString;
import ch.dia.web.servlets.AbstractDiaServlet;
import ch.dia.web.servlets.components.CodeMatcher;
import ch.dia.web.servlets.components.DiaCookieHandler;
import ch.dia.web.servlets.serializer.InformationSerializer;
import ch.dia.web.servlets.serializer.UtilisateurSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.Collections;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilisateurServlet
extends AbstractDiaServlet {
    public static final Logger LOGGER = LoggerFactory.getLogger(UtilisateurServlet.class);
    private final CodeMatcher codeMatcher;
    DiaCookieHandler cookieHandler;
    private SrvInformation srvInformation;
    private SrvConnexion srvConnexion;
    private final Gson userGson = new GsonBuilder().registerTypeHierarchyAdapter(DiaUtilisateur.class, (Object)new UtilisateurSerializer()).create();
    private final Gson infoGson = new GsonBuilder().registerTypeHierarchyAdapter(DiaUtilisateur.class, (Object)new InformationSerializer()).create();

    public UtilisateurServlet() {
        this.cookieHandler = new DiaCookieHandler();
        this.codeMatcher = new CodeMatcher();
    }

    public void init() throws ServletException {
        this.srvInformation = this.getServiceBean(this.getServletConfig().getServletContext(), SrvInformation.class);
        this.srvConnexion = this.getServiceBean(this.getServletConfig().getServletContext(), SrvConnexion.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String datajson = null;
        String sId = StringEscapeUtils.escapeJava((String)this.readString(request, "id"));
        DiaUtilisateur userInRequest = this.getConnectedUser(request);
        if (sId != null && sId.trim().length() > 0) {
            if (!(userInRequest instanceof DiaMedecin)) throw new ServletValidationException(403, "msg.erreurConnexionServeur");
            datajson = this.infoGson.toJson(this.srvInformation.getInformationsByMail(userInRequest.getId(), sId));
        } else {
            datajson = this.infoGson.toJson(Collections.singletonList(userInRequest));
        }
        if (datajson.length() <= 10) {
            throw new ServletValidationException(403, "msg.erreurConnexionServeur");
        }
        this.sendHTMLBody(response, utString.stringNotNull(datajson));
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String code = StringEscapeUtils.escapeJava((String)this.readAndValidateString(request, "c"));
        String hashCode = StringEscapeUtils.escapeJava((String)this.readAndValidateString(request, "hc"));
        String password1 = StringEscapeUtils.escapeJava((String)this.readAndValidateString(request, "p1"));
        int sexe = this.readAndValidateInt(request, "civ");
        String nom = StringEscapeUtils.escapeJava((String)this.readAndValidateString(request, "n"));
        String prenom = StringEscapeUtils.escapeJava((String)this.readAndValidateString(request, "p"));
        String mail = StringEscapeUtils.escapeJava((String)this.readAndValidateString(request, "m"));
        String ma = StringEscapeUtils.escapeJava((String)this.readAndValidateString(request, "ma"));
        String mc = StringEscapeUtils.escapeJava((String)this.readAndValidateString(request, "mc"));
        String mp = StringEscapeUtils.escapeJava((String)this.readAndValidateString(request, "mp"));
        String mt = StringEscapeUtils.escapeJava((String)this.readAndValidateString(request, "mt"));
        String mville = StringEscapeUtils.escapeJava((String)this.readAndValidateString(request, "mville"));
        String mv = StringEscapeUtils.escapeJava((String)this.readAndValidateString(request, "mv"));
        DiaUtilisateur pUser = this.getConnectedUser(request);
        if (pUser.getId() > 0) {
            if (!this.codeMatcher.matchs(code, hashCode)) {
                throw new ServletValidationException("msg.codeErreur");
            }
            String pass = utSha1.SHA1(password1 + pUser.getEmail());
            if (!pUser.getMotpasse().equals(pass)) {
                throw new ServletValidationException(403, "errors.incorrect.password");
            }
            this.sendHTMLBody(response, this.userGson.toJson((Object)this.srvInformation.saveInformations(pUser, sexe, nom, prenom, mail, ma, mc, mp, mt, mville, mv)));
        }
    }
}

