/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.web.servlets.connectServlet;

import ch.dia.model.DiaProfil;
import ch.dia.model.DiaUtilisateur;
import ch.dia.services.SrvConnexion;
import ch.dia.services.SrvProfil;
import ch.dia.utils.utJson;
import ch.dia.web.servlets.AbstractDiaServlet;
import ch.dia.web.servlets.components.DiaCookieHandler;
import ch.dia.web.servlets.connectServlet.PasswordServlet;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilServlet
extends AbstractDiaServlet {
    public static final Logger LOGGER = LoggerFactory.getLogger(PasswordServlet.class);
    private SrvProfil srvProfil;
    private SrvConnexion srvConnexion;
    private final Gson gson = new Gson();
    private final JsonParser jsonParser = new JsonParser();
    private DiaCookieHandler cookieHandler;

    public void init() throws ServletException {
        this.cookieHandler = new DiaCookieHandler();
        this.srvConnexion = this.getServiceBean(this.getServletConfig().getServletContext(), SrvConnexion.class);
        this.srvProfil = this.getServiceBean(this.getServletConfig().getServletContext(), SrvProfil.class);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String sId = this.readString(request, "p");
        DiaUtilisateur user = this.getConnectedUser(request);
        this.sendHTMLBody(response, this.gson.toJson(this.srvProfil.getProfil(user, sId)));
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DiaUtilisateur pUti = null;
        String sMail = this.readString(request, "p");
        String profil = this.readAndValidateString(request, "n");
        String jsonFormattedString = utJson.unescape(profil);
        HttpServletRequest httpRequest = request;
        String lang = this.cookieHandler.getLanguage(httpRequest);
        Locale locale = new Locale.Builder().setLanguage(lang).build();
        if (sMail != null) {
            pUti = this.srvConnexion.getUtilisateurByMail(sMail);
        }
        JsonElement je = this.jsonParser.parse(jsonFormattedString);
        DiaProfil[] pProfil = (DiaProfil[])this.gson.fromJson(je, DiaProfil[].class);
        DiaUtilisateur user = this.getConnectedUser(request);
        this.srvProfil.updateProfil(sMail, pProfil[0], user, locale);
    }
}

