/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.web.servlets.connectServlet;

import ch.dia.model.DiaAdministrateur;
import ch.dia.model.DiaMedecin;
import ch.dia.model.DiaPatient;
import ch.dia.model.DiaUtilisateur;
import ch.dia.services.SrvMedecinPatient;
import ch.dia.utils.utString;
import ch.dia.web.servlets.AbstractDiaServlet;
import ch.dia.web.servlets.connectServlet.PasswordServlet;
import ch.dia.web.servlets.serializer.AdministrateurSerializer;
import ch.dia.web.servlets.serializer.MedecinSerializer;
import ch.dia.web.servlets.serializer.PatientSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatientServlet
extends AbstractDiaServlet {
    public static final Logger LOGGER = LoggerFactory.getLogger(PasswordServlet.class);
    private SrvMedecinPatient srvMedecinPatient;
    private final Gson gsonPatient;
    private final Gson gsonMedecin = new GsonBuilder().registerTypeAdapter(DiaMedecin.class, (Object)new MedecinSerializer()).create();

    public PatientServlet() {
        this.gsonPatient = new GsonBuilder().registerTypeAdapter(DiaPatient.class, (Object)new PatientSerializer()).registerTypeAdapter(DiaMedecin.class, (Object)new PatientSerializer()).registerTypeAdapter(DiaAdministrateur.class, (Object)new AdministrateurSerializer()).create();
    }

    public void init() throws ServletException {
        this.srvMedecinPatient = this.getServiceBean(this.getServletConfig().getServletContext(), SrvMedecinPatient.class);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Object datajson = null;
        boolean choix = utString.stringNotNull(this.readString(request, "m")).equals("1");
        boolean all = utString.stringNotNull(this.readString(request, "a")).equals("1");
        response.setContentType("text/html");
        DiaUtilisateur user = this.getConnectedUser(request);
        if (choix) {
            response.getWriter().write(this.gsonMedecin.toJson(this.srvMedecinPatient.listMedecinsPatient(user, choix, all)));
        } else {
            response.getWriter().write(this.gsonPatient.toJson(this.srvMedecinPatient.listMedecinsPatient(user, choix, all)));
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DiaUtilisateur user = this.getConnectedUser(request);
        this.srvMedecinPatient.setMedecinPatient(user, utString.stringNotNull(this.readString(request, "m")));
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean bPatient = utString.stringNotNull(this.readString(request, "patient")).equals("1");
        DiaUtilisateur diaUtilisateur = this.getConnectedUser(request);
        if (bPatient) {
            String mailMedecin = StringEscapeUtils.escapeJava((String)this.readString(request, "m"));
            String idPatient = StringEscapeUtils.escapeJava((String)this.readString(request, "d"));
            this.srvMedecinPatient.removeMedecinPatient(diaUtilisateur, bPatient, idPatient, mailMedecin);
        } else {
            String mailPatient = StringEscapeUtils.escapeJava((String)this.readString(request, "d"));
            String idMedecin = StringEscapeUtils.escapeJava((String)this.readString(request, "m"));
            this.srvMedecinPatient.removeMedecinPatient(diaUtilisateur, bPatient, mailPatient, idMedecin);
        }
    }
}

