/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.web.servlets.connectServlet;

import ch.dia.model.DiaPatient;
import ch.dia.model.DiaUtilisateur;
import ch.dia.services.SrvInscription;
import ch.dia.utils.ResourceBundleUtils;
import ch.dia.utils.utString;
import ch.dia.web.servlets.AbstractDiaServlet;
import ch.dia.web.servlets.components.CodeMatcher;
import ch.dia.web.servlets.components.DiaCookieHandler;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartageServlet
extends AbstractDiaServlet {
    public static final Logger LOGGER = LoggerFactory.getLogger(PartageServlet.class);
    private final CodeMatcher codeMatcher = new CodeMatcher();
    private DiaCookieHandler cookieHandler;
    private SrvInscription srvInscription;

    public void init() throws ServletException {
        this.cookieHandler = new DiaCookieHandler();
        this.srvInscription = this.getServiceBean(this.getServletConfig().getServletContext(), SrvInscription.class);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String code = StringEscapeUtils.escapeJava((String)this.readAndValidateString(request, "c"));
        String hashCode = StringEscapeUtils.escapeJava((String)this.readAndValidateString(request, "hc"));
        DiaPatient patient = new DiaPatient();
        patient.setNom(utString.stringNotNull(this.readString(request, "n")));
        patient.setPrenom(utString.stringNotNull(this.readString(request, "p")));
        patient.setEmail(utString.stringNotNull(this.readString(request, "m")).toLowerCase());
        patient.setSexe(this.readAndValidateInt(request, "civ"));
        HttpServletRequest httpRequest = request;
        String lang = this.cookieHandler.getLanguage(httpRequest);
        Locale locale = new Locale.Builder().setLanguage(lang).build();
        if (!this.codeMatcher.matchs(code, hashCode)) {
            response.sendError(500, ResourceBundleUtils.getLocalText("msg.codeErreur", locale));
        } else {
            DiaUtilisateur pUser = this.getConnectedUser(request);
            this.srvInscription.addPatientToUser(pUser, patient, locale);
        }
        this.sendHTMLBody(response, ResourceBundleUtils.getLocalText("frm.partage.confirm", locale));
    }
}

