/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.web.servlets.connectServlet;

import ch.dia.exceptions.NoAccessForUserException;
import ch.dia.exceptions.NoEntityFoundException;
import ch.dia.exceptions.ServletValidationException;
import ch.dia.model.DiaDonnees;
import ch.dia.model.DiaUtilisateur;
import ch.dia.model.TypeHoraire;
import ch.dia.services.SrvInjection;
import ch.dia.utils.RequestUtils;
import ch.dia.utils.utDate;
import ch.dia.utils.utJson;
import ch.dia.utils.utString;
import ch.dia.web.servlets.AbstractDiaServlet;
import ch.dia.web.servlets.serializer.DiaDonneesSerializer;
import ch.dia.web.servlets.serializer.InjectionDeserializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectionServlet
extends AbstractDiaServlet {
    public static final Logger LOGGER = LoggerFactory.getLogger(InjectionServlet.class);
    private final JsonParser jsonParser;
    SrvInjection srvInjection;
    final Gson gson = new GsonBuilder().registerTypeAdapter(List.class, (Object)new InjectionDeserializer()).registerTypeAdapter(DiaDonnees.class, (Object)new DiaDonneesSerializer()).create();

    public InjectionServlet() {
        this.jsonParser = new JsonParser();
    }

    public void init() throws ServletException {
        this.srvInjection = this.getServiceBean(this.getServletConfig().getServletContext(), SrvInjection.class);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DiaUtilisateur user = this.getConnectedUser(request);
        Integer idData = this.readInt(request, "idData");
        if (idData != null) {
            this.sendHTMLBody(response, this.gson.toJson((Object)this.srvInjection.getSingleInjection(user, idData)));
        } else {
            this.sendHTMLBody(response, this.gson.toJson(this.srvInjection.listUserInjection(user, RequestUtils.isVersionMobile(request), this.readString(request, "u"), this.readBoolean(request, "l"), this.readInt(request, "g"), this.readEnum(request, "t", TypeHoraire.class), utDate.convertToStringMySql(utDate.convertStringToDate(utString.stringNotNull(this.readString(request, "d")))), utDate.convertToStringMySql(utDate.convertStringToDate(utString.stringNotNull(this.readString(request, "f")))))));
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String url = this.readAndValidateString(request, "n");
        String jsonFormattedString = utJson.unescape(url);
        DiaUtilisateur user = this.getConnectedUser(request);
        DiaDonnees[] diaDonnees = (DiaDonnees[])this.gson.fromJson(this.jsonParser.parse(jsonFormattedString), DiaDonnees[].class);
        this.srvInjection.saveUserDonnees(user, diaDonnees);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.srvInjection.removeInjection(this.getConnectedUser(request), this.readAndValidateInt(request, "d"));
        }
        catch (NoAccessForUserException e) {
            throw new ServletValidationException(403, "errors.noaccces", e.getMessage());
        }
        catch (NoEntityFoundException e) {
            throw new ServletValidationException(404, "errors.noentity", e.getMessage());
        }
    }
}

