/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.web.servlets.connectServlet;

import ch.dia.exceptions.ServletValidationException;
import ch.dia.model.DiaUtilisateur;
import ch.dia.services.SrvImport;
import ch.dia.utils.utString;
import ch.dia.web.servlets.AbstractDiaServlet;
import ch.dia.web.servlets.connectServlet.ExportServlet;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/fileUpload"})
@MultipartConfig(maxFileSize=16177215L)
public class ImportServlet
extends AbstractDiaServlet {
    public static final Logger LOGGER = LoggerFactory.getLogger(ExportServlet.class);
    private SrvImport srvImport;

    public void init() throws ServletException {
        this.srvImport = this.getServiceBean(this.getServletConfig().getServletContext(), SrvImport.class);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int nbData = 0;
        boolean freeStyle = utString.stringNotNull(this.readString(request, "typeFreeStyle")).equals("on");
        DiaUtilisateur user = this.getConnectedUser(request);
        InputStream inputStream = this.getFile(request, "fichier");
        if (inputStream == null) {
            throw new ServletValidationException("errors.file.capteur");
        }
        nbData = this.srvImport.importData(user, inputStream, freeStyle);
        this.sendHTMLBody(response, Integer.toString(nbData));
    }

    private InputStream getFile(HttpServletRequest request, String img) throws ServletException, IOException {
        InputStream inputStream = null;
        Part filePart = request.getPart(img);
        if (filePart != null && filePart.getSize() > 0L) {
            inputStream = filePart.getInputStream();
        }
        return inputStream;
    }
}

