/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.web.servlets.connectServlet;

import ch.dia.model.DiaComposition;
import ch.dia.model.DiaUtilisateur;
import ch.dia.services.SrvFavoris;
import ch.dia.utils.utString;
import ch.dia.web.servlets.AbstractDiaServlet;
import ch.dia.web.servlets.serializer.CompositionSerializer;
import ch.dia.web.servlets.serializer.RepasDeserializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FavorisServlet
extends AbstractDiaServlet {
    public static final Logger LOGGER = LoggerFactory.getLogger(FavorisServlet.class);
    SrvFavoris srvFavoris;
    private final JsonParser jsonParser;
    private final Gson gson = new GsonBuilder().registerTypeAdapter(List.class, (Object)new RepasDeserializer()).registerTypeAdapter(DiaComposition.class, (Object)new CompositionSerializer()).create();

    public FavorisServlet() {
        this.jsonParser = new JsonParser();
    }

    public void init() throws ServletException {
        this.srvFavoris = this.getServiceBean(this.getServletConfig().getServletContext(), SrvFavoris.class);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DiaUtilisateur user = this.getConnectedUser(request);
        this.sendHTMLBody(response, this.gson.toJson(this.srvFavoris.getUserRepas(user)));
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String dataStore = this.readAndValidateString(request, "r");
        List lstRepas = (List)this.gson.fromJson(this.jsonParser.parse(dataStore), List.class);
        DiaUtilisateur user = this.getConnectedUser(request);
        this.srvFavoris.saveUserRepas(user, lstRepas);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int idData = utString.stringNotNullToInt(this.readString(request, "n"));
        DiaUtilisateur user = this.getConnectedUser(request);
        this.srvFavoris.deleteFavoris(user, idData);
    }
}

