/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.web.servlets.connectServlet;

import ch.dia.model.DiaDonnees;
import ch.dia.model.TypeHoraire;
import ch.dia.services.SrvConnexion;
import ch.dia.services.SrvExport;
import ch.dia.utils.ResourceBundleUtils;
import ch.dia.utils.utDate;
import ch.dia.utils.utString;
import ch.dia.web.servlets.AbstractDiaServlet;
import ch.dia.web.servlets.components.DiaCookieHandler;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportServlet
extends AbstractDiaServlet {
    public static final Logger LOGGER = LoggerFactory.getLogger(ExportServlet.class);
    private SrvExport srvExport;
    private SrvConnexion srvConnexion;
    private DiaCookieHandler cookieHandler;

    public void init() throws ServletException {
        this.cookieHandler = new DiaCookieHandler();
        this.srvExport = this.getServiceBean(this.getServletConfig().getServletContext(), SrvExport.class);
        this.srvConnexion = this.getServiceBean(this.getServletConfig().getServletContext(), SrvConnexion.class);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int idUser = 0;
        String sId = this.readAndValidateString(request, "u");
        int glycemieAuto = utString.stringNotNullToInt(this.readString(request, "g"));
        String sHoraire = this.readAndValidateString(request, "t");
        String sDebut = utDate.convertToStringMySql(utDate.convertStringToDate(this.readAndValidateString(request, "d")));
        String sFin = utDate.convertToStringMySql(utDate.convertStringToDate(this.readAndValidateString(request, "f")));
        idUser = sId != null && !sId.equals("0") || sId.length() > 1 ? this.srvConnexion.getIdShaUtilisateur(sId).getId().intValue() : this.getConnectedUser(request).getId().intValue();
        HttpServletRequest httpRequest = request;
        String lang = this.cookieHandler.getLanguage(httpRequest);
        Locale locale = new Locale.Builder().setLanguage(lang).build();
        response.reset();
        response.setHeader("Content-Type", "text/csv");
        response.setHeader("Content-Disposition", "attachment; filename=\"export.csv\"");
        if (sHoraire == null || sHoraire.trim().length() == 0) {
            sHoraire = "u0";
        }
        this.dump((OutputStream)response.getOutputStream(), locale, this.srvExport.exportCSVUserData(idUser, glycemieAuto, sDebut, sFin, TypeHoraire.valueOf(sHoraire)));
    }

    private void dump(OutputStream outputStream, Locale locale, List<DiaDonnees> export) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));
        writer.append(ResourceBundleUtils.getLocalText("msg.export.date", locale));
        writer.append(ResourceBundleUtils.getLocalText("msg.export.heure", locale));
        writer.append(ResourceBundleUtils.getLocalText("msg.export.hdc", locale));
        writer.append(ResourceBundleUtils.getLocalText("msg.export.glycemie", locale));
        writer.append(ResourceBundleUtils.getLocalText("msg.export.injection", locale));
        writer.append(ResourceBundleUtils.getLocalText("msg.export.commentaire", locale));
        for (DiaDonnees data : export) {
            writer.append(data.getDateInj()).append(";");
            writer.append(data.getTimeInj()).append(";");
            writer.append(String.valueOf(data.getNbHdc())).append(";");
            writer.append(String.valueOf(data.getGlycemie())).append(";");
            writer.append(String.valueOf(data.getInjection())).append(";");
            writer.append(data.getCommentaire()).append("\n");
        }
        writer.close();
    }
}

