/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.web.servlets.components;

import ch.dia.utils.RequestUtils;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DiaCookieHandler {
    public static final String USER_DIA = "userDia";
    public static final String LANG_DIA = "langue";
    public static final String TOKEN_DIA = "token";

    public void remove(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie c : cookies) {
                if (!c.getName().equals(USER_DIA)) continue;
                c.setValue(null);
                c.setMaxAge(0);
            }
        }
    }

    public String get(HttpServletRequest request) {
        String sValue = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie c : cookies) {
                if (!c.getName().equals(USER_DIA)) continue;
                sValue = c.getValue();
            }
        }
        return sValue;
    }

    public String getLanguage(HttpServletRequest request) {
        String sValue = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie c : cookies) {
                if (!c.getName().equals(LANG_DIA)) continue;
                sValue = c.getValue();
            }
        }
        return sValue;
    }

    public String getToken(HttpServletRequest request) {
        String sValue = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie c : cookies) {
                if (!c.getName().equals(TOKEN_DIA)) continue;
                sValue = c.getValue();
            }
        }
        return sValue;
    }

    public void removeToken(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie c : cookies) {
                if (!c.getName().equals(TOKEN_DIA)) continue;
                c.setValue(null);
                c.setMaxAge(0);
            }
        }
    }

    public void setToken(HttpServletRequest request, HttpServletResponse response, String value) {
        Cookie cookie = new Cookie(TOKEN_DIA, value);
        cookie.setMaxAge(1200);
        response.addCookie(cookie);
    }

    public void setCookie(HttpServletRequest request, HttpServletResponse response, String value) {
        Cookie cookie = new Cookie(USER_DIA, value);
        cookie.setSecure(true);
        if (RequestUtils.isVersionMobile(request)) {
            cookie.setMaxAge(31536000);
        }
        response.addCookie(cookie);
    }
}

