/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.web.servlets;

import ch.dia.exceptions.ServletValidationException;
import ch.dia.model.DiaUtilisateur;
import ch.dia.services.SrvInscription;
import ch.dia.web.servlets.AbstractDiaServlet;
import ch.dia.web.servlets.components.CodeMatcher;
import ch.dia.web.servlets.components.DiaCookieHandler;
import ch.dia.web.servlets.serializer.UtilisateurSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InscriptionServlet
extends AbstractDiaServlet {
    public static final Logger LOGGER = LoggerFactory.getLogger(InscriptionServlet.class);
    private final Gson gson;
    SrvInscription srvInscription;
    CodeMatcher codeMatcher = new CodeMatcher();
    DiaCookieHandler cookieHandler;

    public InscriptionServlet() {
        this.gson = new GsonBuilder().registerTypeHierarchyAdapter(DiaUtilisateur.class, (Object)new UtilisateurSerializer()).create();
    }

    public void init() throws ServletException {
        this.cookieHandler = new DiaCookieHandler();
        this.srvInscription = this.getServiceBean(this.getServletConfig().getServletContext(), SrvInscription.class);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String m = this.readAndValidateString(request, "m");
        String code = this.readAndValidateString(request, "c");
        String hashCode = this.readAndValidateString(request, "hc");
        boolean bMedecin = this.readAndValidateBoolean(request, "medecin");
        if (this.srvInscription.getUtilisateurByMail(m) != null) {
            throw new ServletValidationException("errors.user.already.existing");
        }
        if (!this.codeMatcher.matchs(code, hashCode)) {
            throw new ServletValidationException("errors.code.validation.failed");
        }
        HttpServletRequest httpRequest = request;
        String lang = this.cookieHandler.getLanguage(httpRequest);
        Locale locale = new Locale.Builder().setLanguage(lang).build();
        DiaUtilisateur newUser = !bMedecin ? this.srvInscription.createNewPatient(this.readAndValidateInt(request, "civ"), this.readAndValidateString(request, "n"), this.readAndValidateString(request, "p"), this.readAndValidateString(request, "m"), this.readAndValidateString(request, "p1"), locale) : this.srvInscription.createNewMedecin(this.readAndValidateInt(request, "civ"), this.readAndValidateString(request, "n"), this.readAndValidateString(request, "p"), this.readAndValidateString(request, "m"), this.readAndValidateString(request, "p1"), this.readAndValidateString(request, "ma"), this.readAndValidateString(request, "mc"), this.readAndValidateString(request, "mp"), this.readAndValidateString(request, "mt"), this.readAndValidateString(request, "mville"), this.readAndValidateString(request, "mv"), locale);
        this.sendHTMLBody(response, this.gson.toJson((Object)newUser));
    }
}

