/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.web.servlets;

import ch.dia.exceptions.ServletValidationException;
import ch.dia.model.DiaUtilisateur;
import ch.dia.services.SrvConnexion;
import ch.dia.services.SrvInscription;
import ch.dia.utils.RequestUtils;
import ch.dia.utils.utString;
import ch.dia.web.servlets.AbstractDiaServlet;
import ch.dia.web.servlets.components.DiaCookieHandler;
import ch.dia.web.servlets.serializer.UtilisateurSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnexionServlet
extends AbstractDiaServlet {
    public static final Logger LOGGER = LoggerFactory.getLogger(ConnexionServlet.class);
    DiaCookieHandler cookieHandler;
    SrvConnexion srvConnexion;
    SrvInscription srvInscription;
    private final Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(DiaUtilisateur.class, (Object)new UtilisateurSerializer()).create();

    public ConnexionServlet() {
        this.cookieHandler = new DiaCookieHandler();
    }

    public void init() throws ServletException {
        this.srvConnexion = this.getServiceBean(this.getServletConfig().getServletContext(), SrvConnexion.class);
        this.srvInscription = this.getServiceBean(this.getServletConfig().getServletContext(), SrvInscription.class);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String mail = StringEscapeUtils.escapeJava((String)this.readAndValidateString(request, "e"));
        HttpServletRequest httpRequest = request;
        String lang = this.cookieHandler.getLanguage(httpRequest);
        Locale locale = new Locale.Builder().setLanguage(lang).build();
        this.srvInscription.generateNewPassord(mail, locale);
    }

    protected boolean isConnected(HttpServletRequest request) {
        DiaUtilisateur pUti = this.srvConnexion.getIdShaUtilisateur(utString.stringNotNull(this.cookieHandler.get(request)));
        boolean retour = pUti != null;
        request.setAttribute("USER", (Object)pUti);
        return retour;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DiaUtilisateur pUti = null;
        String e = StringEscapeUtils.escapeJava((String)this.readAndValidateString(request, "e")).toLowerCase();
        String p = StringEscapeUtils.escapeJava((String)this.readAndValidateString(request, "p"));
        if (e.length() > 0 && p.length() > 0) {
            pUti = this.srvConnexion.connexion(e, p);
            if (pUti == null) {
                throw new ServletValidationException(403, "errors.incorrect.connection");
            }
        } else if (e.length() > 0 && p.length() == 0) {
            pUti = this.srvConnexion.getIdUtilisateur(e);
        } else {
            String idSha = this.cookieHandler.get(request);
            if (idSha != null) {
                pUti = this.srvConnexion.getIdShaUtilisateur(idSha);
            }
        }
        if (pUti != null) {
            RequestUtils.setDiaUtilisateur(request, pUti);
            this.sendHTMLBody(response, this.gson.toJson((Object)pUti));
            this.cookieHandler.setCookie(request, response, pUti.getIdSha());
        } else {
            this.cookieHandler.remove(request);
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.cookieHandler.remove(request);
    }
}

