/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.web.servlets;

import ch.dia.exceptions.ServletValidationException;
import ch.dia.model.DiaUtilisateur;
import ch.dia.utils.RequestUtils;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public abstract class AbstractDiaServlet
extends HttpServlet {
    protected <T> T getServiceBean(ServletContext servletContext, Class<T> clazz) {
        return (T)servletContext.getAttribute(clazz.getName());
    }

    protected String readString(HttpServletRequest request, String paramName) throws ServletValidationException {
        String prm = StringEscapeUtils.escapeJava((String)request.getParameter(paramName.trim()));
        if (prm == null) {
            return null;
        }
        Document doc = Jsoup.parse((String)prm);
        prm = doc.text();
        return prm.trim();
    }

    protected Integer readInt(HttpServletRequest request, String paramName) throws ServletValidationException {
        String prm = StringEscapeUtils.escapeJava((String)request.getParameter(paramName.trim()));
        if (prm == null) {
            return null;
        }
        Document doc = Jsoup.parse((String)prm);
        prm = doc.text();
        try {
            return Integer.valueOf(prm);
        }
        catch (NumberFormatException e) {
            throw new ServletValidationException("errors.bad.parameter", "Parameter <" + paramName + "> value : <" + prm + "> is not an integer", e);
        }
    }

    protected Boolean readBoolean(HttpServletRequest request, String paramName) throws ServletValidationException {
        String prm = StringEscapeUtils.escapeJava((String)request.getParameter(paramName.trim()));
        if (prm == null) {
            return null;
        }
        Document doc = Jsoup.parse((String)prm);
        prm = doc.text();
        try {
            Integer integer = Integer.valueOf(prm);
            if (integer == 1) {
                return Boolean.TRUE;
            }
            if (integer == 0) {
                return Boolean.FALSE;
            }
            throw new ServletValidationException("errors.bad.parameter", "Parameter <" + paramName + "> value : <" + prm + "> is not readable as a boolean ");
        }
        catch (NumberFormatException e) {
            throw new ServletValidationException("errors.bad.parameter", "Parameter <" + paramName + "> value : <" + prm + "> is not readable as a integer/boolean ", e);
        }
    }

    protected <T extends Enum> T readEnum(HttpServletRequest request, String paramName, Class<T> clazz) throws ServletValidationException {
        String paramValue = StringEscapeUtils.escapeJava((String)request.getParameter(paramName.trim()));
        if (paramValue == null) {
            return null;
        }
        Document doc = Jsoup.parse((String)paramValue);
        T t = this.getEnumValue(clazz, paramValue = doc.text());
        if (t != null) {
            return t;
        }
        throw new ServletValidationException(400, "errors.bad.parameter", "Parameter <" + paramName + "> value : <" + request.getParameter(paramName) + "> is not a valid Enum for class <" + clazz.getName() + ">");
    }

    private <T extends Enum> T getEnumValue(Class<T> clazz, String paramValue) {
        for (Enum t : (Enum[])clazz.getEnumConstants()) {
            if (!t.name().equals(paramValue)) continue;
            return (T)t;
        }
        return null;
    }

    protected int readAndValidateInt(HttpServletRequest request, String paramName) throws ServletValidationException {
        String strParam = this.readAndValidateString(request, paramName);
        try {
            return Integer.valueOf(strParam);
        }
        catch (NumberFormatException e) {
            throw new ServletValidationException(400, "errors.bad.parameter", "Parameter <" + paramName + "> value : <" + strParam + "> is not a valid integer");
        }
    }

    protected String readAndValidateString(HttpServletRequest request, String paramName) throws ServletValidationException {
        if (request.getParameter(paramName) == null) {
            throw new ServletValidationException(400, "errors.missing.parameter", "Parameter <" + paramName + "> is not present");
        }
        Document doc = Jsoup.parse((String)StringEscapeUtils.escapeJava((String)request.getParameter(paramName.trim())));
        return doc.text();
    }

    protected boolean readAndValidateBoolean(HttpServletRequest request, String paramName) throws ServletValidationException {
        String strParam = this.readAndValidateString(request, paramName);
        if (!strParam.equals("1") && !"0".equals(strParam)) {
            throw new ServletValidationException(400, "errors.bad.parameter", "Parameter <" + paramName + "> value : <" + strParam + "> is not a boolean");
        }
        return "1".equals(strParam);
    }

    protected void sendHTMLBody(HttpServletResponse response, String body) throws IOException {
        response.setContentType("text/html; charset=UTF-8");
        response.getWriter().write(body);
    }

    protected void sendJSONBody(HttpServletResponse response, String body) throws IOException {
        response.setContentType("application/json");
        response.getWriter().write(body);
    }

    protected DiaUtilisateur getConnectedUser(HttpServletRequest request) {
        return RequestUtils.getDiaUtilisateur(request);
    }
}

