/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.web.listeners;

import ch.dia.dao.DaoAccesUtilisateur;
import ch.dia.dao.DaoAliment;
import ch.dia.dao.DaoDonnees;
import ch.dia.dao.DaoFamilleAliment;
import ch.dia.dao.DaoImageAliment;
import ch.dia.dao.DaoProfil;
import ch.dia.dao.DaoRepas;
import ch.dia.dao.DaoUtilisateur;
import ch.dia.services.SrvAliments;
import ch.dia.services.SrvConnexion;
import ch.dia.services.SrvContact;
import ch.dia.services.SrvExport;
import ch.dia.services.SrvFavoris;
import ch.dia.services.SrvImport;
import ch.dia.services.SrvInformation;
import ch.dia.services.SrvInjection;
import ch.dia.services.SrvInscription;
import ch.dia.services.SrvMedecinPatient;
import ch.dia.services.SrvPassword;
import ch.dia.services.SrvProfil;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class DiaInitListener
implements ServletContextListener {
    public static final String MAIN_PU = "DiaPU";
    private EntityManagerFactory entityManagerFactory;
    private EntityManager entityManager;

    public void contextInitialized(ServletContextEvent sce) {
        try {
            ServletContext sc = sce.getServletContext();
            this.entityManagerFactory = Persistence.createEntityManagerFactory((String)MAIN_PU);
            this.entityManager = this.entityManagerFactory.createEntityManager();
            this.registerServices(sc, this.entityManager);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize Context", e);
        }
    }

    private void registerServices(ServletContext sc, EntityManager entityManager) {
        DaoUtilisateur utilisateurOm = new DaoUtilisateur(entityManager);
        DaoAliment alimentOm = new DaoAliment(entityManager);
        DaoFamilleAliment familleAlimentOm = new DaoFamilleAliment(entityManager);
        DaoImageAliment imageAlimentOm = new DaoImageAliment(entityManager);
        DaoDonnees donneesOm = new DaoDonnees(entityManager);
        DaoAccesUtilisateur accesUtilisateurOm = new DaoAccesUtilisateur(entityManager);
        DaoProfil profilOm = new DaoProfil(entityManager);
        DaoRepas repasOm = new DaoRepas(entityManager);
        sc.setAttribute(EntityManager.class.getName(), (Object)entityManager);
        sc.setAttribute(SrvAliments.class.getName(), (Object)new SrvAliments(familleAlimentOm, alimentOm, imageAlimentOm));
        sc.setAttribute(SrvConnexion.class.getName(), (Object)new SrvConnexion(utilisateurOm));
        sc.setAttribute(SrvContact.class.getName(), (Object)new SrvContact());
        sc.setAttribute(SrvExport.class.getName(), (Object)new SrvExport(donneesOm));
        sc.setAttribute(SrvFavoris.class.getName(), (Object)new SrvFavoris(repasOm));
        sc.setAttribute(SrvInformation.class.getName(), (Object)new SrvInformation(utilisateurOm, accesUtilisateurOm));
        SrvInjection srvInjection = new SrvInjection(donneesOm, utilisateurOm, accesUtilisateurOm);
        sc.setAttribute(SrvInjection.class.getName(), (Object)srvInjection);
        sc.setAttribute(SrvInscription.class.getName(), (Object)new SrvInscription(utilisateurOm, accesUtilisateurOm));
        sc.setAttribute(SrvMedecinPatient.class.getName(), (Object)new SrvMedecinPatient(utilisateurOm, accesUtilisateurOm));
        sc.setAttribute(SrvPassword.class.getName(), (Object)new SrvPassword(utilisateurOm));
        sc.setAttribute(SrvProfil.class.getName(), (Object)new SrvProfil(utilisateurOm, profilOm));
        sc.setAttribute(SrvImport.class.getName(), (Object)new SrvImport(donneesOm));
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.entityManager.close();
        this.entityManagerFactory.close();
    }
}

