/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.utils;

public class utJson {
    public static String escape(String input) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char ch;
            char chx = ch = input.charAt(i);
            assert (chx != '\u0000');
            if (ch == '\n') {
                output.append("\\n");
                continue;
            }
            if (ch == '\t') {
                output.append("\\t");
                continue;
            }
            if (ch == '\r') {
                output.append("\\r");
                continue;
            }
            if (ch == '\\') {
                output.append("\\\\");
                continue;
            }
            if (ch == '\"') {
                output.append("\\\"");
                continue;
            }
            if (ch == '\b') {
                output.append("\\b");
                continue;
            }
            if (ch == '\f') {
                output.append("\\f");
                continue;
            }
            if (chx >= '\u10000') {
                assert (false) : "Java stores as u16, so it should never give us a character that's bigger than 2 bytes. It literally can't.";
                continue;
            }
            if (chx > '\u007f') {
                output.append(String.format("\\u%04x", chx));
                continue;
            }
            output.append(ch);
        }
        return output.toString();
    }

    public static String unescape(String input) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < input.length()) {
            char delimiter = input.charAt(i);
            if (delimiter == '\\' && ++i < input.length()) {
                char ch = input.charAt(i);
                ++i;
                if (ch == '\\' || ch == '/' || ch == '\"' || ch == '\'') {
                    builder.append(ch);
                    continue;
                }
                if (ch == 'n') {
                    builder.append('\n');
                    continue;
                }
                if (ch == 'r') {
                    builder.append('\r');
                    continue;
                }
                if (ch == 't') {
                    builder.append('\t');
                    continue;
                }
                if (ch == 'b') {
                    builder.append('\b');
                    continue;
                }
                if (ch == 'f') {
                    builder.append('\f');
                    continue;
                }
                if (ch == 'u') {
                    StringBuilder hex = new StringBuilder();
                    if (i + 4 > input.length()) {
                        throw new RuntimeException("Not enough unicode digits! ");
                    }
                    for (char x : input.substring(i, i + 4).toCharArray()) {
                        if (!Character.isLetterOrDigit(x)) {
                            throw new RuntimeException("Bad character in unicode escape.");
                        }
                        hex.append(Character.toLowerCase(x));
                    }
                    i += 4;
                    int code = Integer.parseInt(hex.toString(), 16);
                    builder.append((char)code);
                    continue;
                }
                throw new RuntimeException("Illegal escape sequence: \\" + ch);
            }
            builder.append(delimiter);
        }
        return builder.toString();
    }
}

