/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.utils.calendar;

import ch.dia.utils.calendar.utNumberTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Calendar;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class utSpinNumberField
extends JPanel
implements AdjustmentListener,
ActionListener,
FocusListener {
    protected utNumberTextField textField;
    protected JScrollBar scrollBar;
    private int min = 0;
    private int max = 0;
    private int value = 0;

    public utSpinNumberField(int min, int max, int value) {
        this.max = max;
        this.min = min;
        this.value = value;
        this.setLayout(new BorderLayout());
        Calendar calendar = Calendar.getInstance();
        this.textField = new utNumberTextField(4);
        this.textField.setInt(value);
        this.textField.setHorizontalAlignment(4);
        this.textField.setPreferredSize(new Dimension(new JTextField((String)String.valueOf((int)this.max)).getPreferredSize().width, this.textField.getPreferredSize().height));
        this.add((Component)this.textField, "Center");
        this.scrollBar = new JScrollBar(1, value, 0, min, max);
        this.scrollBar.setPreferredSize(new Dimension(this.scrollBar.getPreferredSize().width, this.textField.getPreferredSize().height));
        this.scrollBar.setValue(max + min - value);
        this.scrollBar.setVisibleAmount(0);
        this.add((Component)this.scrollBar, "East");
        this.textField.addFocusListener(this);
        this.textField.addActionListener(this);
        this.scrollBar.addAdjustmentListener(this);
    }

    public utSpinNumberField(int min, int max) {
        this(min, max, 0);
    }

    public void setValue(int val) {
        int j = this.value;
        this.value = val < this.min ? this.min : (val > this.max ? this.max : val);
        this.textField.setInt(this.value);
        this.scrollBar.setValue(this.max + this.min - this.value);
        this.firePropertyChange("value", j, this.value);
    }

    public int getValue() {
        return this.value;
    }

    public void setMinimum(int min) {
        if (min < 0 && !this.textField.isAllowNegative()) {
            this.min = 0;
        }
        this.min = min;
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMaximum(int max) {
        if (max < 0 && !this.textField.isAllowNegative()) {
            this.max = 0;
        }
        this.textField.setPreferredSize(new Dimension(new JTextField((String)Integer.toString((int)max)).getPreferredSize().width, this.textField.getPreferredSize().height));
        this.max = max;
    }

    public int getMaximum() {
        return this.max;
    }

    @Override
    public void setFont(Font font) {
        if (this.textField != null) {
            this.textField.setFont(font);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentevent) {
        this.setValue(this.max + this.min - adjustmentevent.getValue());
    }

    @Override
    public void actionPerformed(ActionEvent actionevent) {
        this.setValue(this.textField.getInt());
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object object = e.getSource();
        if (object instanceof JTextComponent) {
            this.setValue(this.textField.getInt());
        }
    }

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.textField.setEnabled(flag);
        this.scrollBar.setEnabled(flag);
    }
}

