/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.utils.calendar;

import java.awt.Color;
import javax.swing.JTextField;
import javax.swing.text.PlainDocument;

public class utNumberTextField
extends JTextField {
    private static final char DOT = '.';
    private static final char NEGATIVE = '-';
    private static final String BLANK = "";
    private static final int DEF_PRECISION = 2;
    public static final int NUMERIC = 2;
    public static final int DECIMAL = 3;
    public static final String FM_NUMERIC = "0123456789";
    public static final String FM_DECIMAL = "0123456789.";
    private int maxLength = 0;
    private int format = 2;
    private String negativeChars = "";
    private String allowedChars = null;
    private boolean allowNegative = false;
    private int precision = 0;
    protected PlainDocument numberFieldFilter;

    public utNumberTextField(int iMaxLen) {
        this(iMaxLen, 2);
    }

    public utNumberTextField(int iMaxLen, int iFormat) {
        this.setMaxLength(iMaxLen);
        this.setFormat(iFormat);
    }

    public void setMaxLength(int maxLen) {
        this.maxLength = maxLen > 0 ? maxLen : 0;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        if (enable) {
            this.setBackground(Color.white);
            this.setForeground(Color.black);
        } else {
            this.setBackground(Color.lightGray);
            this.setForeground(Color.darkGray);
        }
    }

    @Override
    public void setEditable(boolean enable) {
        super.setEditable(enable);
        if (enable) {
            this.setBackground(Color.white);
            this.setForeground(Color.black);
        } else {
            this.setBackground(Color.lightGray);
            this.setForeground(Color.darkGray);
        }
    }

    public void setPrecision(int iPrecision) {
        if (this.format == 2) {
            return;
        }
        this.precision = iPrecision >= 0 ? iPrecision : 2;
    }

    public int getPrecision() {
        return this.precision;
    }

    public Number getNumber() {
        Number number = null;
        number = this.format == 2 ? (Number)new Integer(this.getText()) : (Number)new Double(this.getText());
        return number;
    }

    public void setNumber(Number value) {
        this.setText(String.valueOf(value));
    }

    public int getInt() {
        return Integer.parseInt(this.getText());
    }

    public void setInt(int value) {
        this.setText(String.valueOf(value));
    }

    public float getFloat() {
        return new Float(this.getText()).floatValue();
    }

    public void setFloat(float value) {
        this.setText(String.valueOf(value));
    }

    public double getDouble() {
        return new Double(this.getText());
    }

    public void setDouble(double value) {
        this.setText(String.valueOf(value));
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int iFormat) {
        switch (iFormat) {
            default: {
                this.format = 2;
                this.precision = 0;
                this.allowedChars = FM_NUMERIC;
                break;
            }
            case 3: {
                this.format = 3;
                this.precision = 2;
                this.allowedChars = FM_DECIMAL;
            }
        }
    }

    public void setAllowNegative(boolean b) {
        this.allowNegative = b;
        this.negativeChars = b ? "-" : BLANK;
    }

    public boolean isAllowNegative() {
        return this.allowNegative;
    }
}

