/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.utils.calendar;

import ch.dia.utils.calendar.JDayChooser;
import ch.dia.utils.calendar.JMonthChooser;
import ch.dia.utils.calendar.JYearChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class utCalendar
extends JDialog
implements PropertyChangeListener {
    protected JYearChooser yearChooser;
    protected JMonthChooser monthChooser;
    protected JDayChooser dayChooser;
    public static final int RIGHT_SPINNER = 0;
    public static final int LEFT_SPINNER = 1;
    public static final int NO_SPINNER = 2;
    protected JButton btnOk;
    protected JButton btnCancel;
    protected boolean okPressed = false;
    private Calendar calendar;

    public utCalendar(Frame parent, String title, boolean modal) {
        this(parent, title, modal, 0);
    }

    public utCalendar(Frame parent, String title, boolean modal, int monthSpinner) {
        super(parent, title, modal);
        this.init(monthSpinner);
    }

    public utCalendar(Dialog parent, String title, boolean modal) {
        super(parent, title, modal);
        this.init(0);
    }

    private void init(int monthSpinner) {
        this.okPressed = false;
        this.getContentPane().setLayout(new BorderLayout());
        this.calendar = Calendar.getInstance();
        this.dayChooser = new JDayChooser(this.calendar.get(5));
        this.monthChooser = new JMonthChooser(monthSpinner, this.calendar.get(2));
        this.yearChooser = new JYearChooser(this.calendar.get(1));
        this.btnOk = new JButton("Ok");
        this.btnCancel = new JButton("Annuler");
        this.monthChooser.setYearChooser(this.yearChooser);
        this.monthChooser.setDayChooser(this.dayChooser);
        this.yearChooser.setDayChooser(this.dayChooser);
        JPanel pnlTop = new JPanel();
        pnlTop.setLayout(new GridLayout(1, 3));
        pnlTop.add(this.monthChooser);
        pnlTop.add(this.yearChooser);
        JPanel pnlBottom = new JPanel();
        pnlBottom.add(this.btnOk);
        pnlBottom.add(this.btnCancel);
        this.getContentPane().add((Component)pnlTop, "North");
        this.getContentPane().add((Component)this.dayChooser, "Center");
        this.getContentPane().add((Component)pnlBottom, "South");
        this.pack();
        this.setResizable(false);
        this.dayChooser.addPropertyChangeListener(this);
        this.monthChooser.addPropertyChangeListener(this);
        this.yearChooser.addPropertyChangeListener(this);
        SymAction lSymAction = new SymAction();
        this.btnOk.addActionListener(lSymAction);
        this.btnCancel.addActionListener(lSymAction);
    }

    private void btnOk_ActionPerformed(ActionEvent event) {
        this.okPressed = true;
        this.closeWindow();
    }

    private void btnCancel_ActionPerformed(ActionEvent event) {
        this.okPressed = false;
        this.closeWindow();
    }

    private void closeWindow() {
        this.setVisible(false);
        this.dispose();
    }

    private void setCalendar(Calendar date, boolean flag) {
        Calendar cDate = this.calendar;
        this.calendar = date;
        if (flag) {
            this.yearChooser.setYear(date.get(1));
            this.monthChooser.setMonth(date.get(2));
            this.dayChooser.setDay(date.get(5));
        }
        this.firePropertyChange("calendar", cDate, this.calendar);
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public void setCalendar(Calendar date) {
        this.setCalendar(date, true);
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setDate(Date uDate) {
        Calendar cDate = Calendar.getInstance(Locale.getDefault());
        if (uDate != null) {
            cDate.clear();
            cDate.setTime(uDate);
        }
        this.setCalendar(cDate, true);
    }

    public Date getDate() {
        return this.calendar.getTime();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.dayChooser != null) {
            this.dayChooser.setFont(font);
            this.monthChooser.setFont(font);
            this.yearChooser.setFont(font);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.dayChooser != null) {
            this.dayChooser.setForeground(color);
            this.monthChooser.setForeground(color);
            this.yearChooser.setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.dayChooser != null) {
            this.dayChooser.setBackground(color);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertychangeevent) {
        if (this.calendar != null) {
            Calendar cDate = (Calendar)this.calendar.clone();
            if (propertychangeevent.getPropertyName().equals("day")) {
                cDate.set(5, (Integer)propertychangeevent.getNewValue());
                this.setCalendar(cDate, false);
            } else if (propertychangeevent.getPropertyName().equals("month")) {
                cDate.set(2, (Integer)propertychangeevent.getNewValue());
                this.setCalendar(cDate, false);
            } else if (propertychangeevent.getPropertyName().equals("year")) {
                cDate.set(1, (Integer)propertychangeevent.getNewValue());
                this.setCalendar(cDate, false);
            }
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            Rectangle bounds = this.getParent().getBounds();
            Rectangle abounds = this.getBounds();
            this.setLocation(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
            this.okPressed = false;
        }
        super.setVisible(b);
    }

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        if (this.dayChooser != null) {
            this.dayChooser.setEnabled(flag);
            this.monthChooser.setEnabled(flag);
            this.yearChooser.setEnabled(flag);
        }
    }

    public JDayChooser getDayChooser() {
        return this.dayChooser;
    }

    public JMonthChooser getMonthChooser() {
        return this.monthChooser;
    }

    public JYearChooser getYearChooser() {
        return this.yearChooser;
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == utCalendar.this.btnOk) {
                utCalendar.this.btnOk_ActionPerformed(event);
            } else if (object == utCalendar.this.btnCancel) {
                utCalendar.this.btnCancel_ActionPerformed(event);
            }
        }
    }
}

