/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.utils.calendar;

import ch.dia.utils.calendar.JDayChooser;
import ch.dia.utils.calendar.JYearChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

class JMonthChooser
extends JPanel
implements ItemListener,
AdjustmentListener {
    public static final int RIGHT_SPINNER = 0;
    public static final int LEFT_SPINNER = 1;
    public static final int NO_SPINNER = 2;
    private static final DateFormatSymbols dfSymb = new DateFormatSymbols();
    private static final String[] SHORT_MONTHS = dfSymb.getShortMonths();
    private static final String[] MONTHS = dfSymb.getMonths();
    private int oldBarValue = 0;
    private int month = 0;
    private JDayChooser dayChooser = null;
    private JYearChooser yearChooser = null;
    private JComboBox comboBox;
    private JScrollBar scrollBar;

    public JMonthChooser() {
        this(0, Calendar.getInstance(Locale.getDefault()).get(2));
    }

    public JMonthChooser(int spinner, int month) {
        this.setLayout(new BorderLayout());
        this.comboBox = new JComboBox();
        for (int i = 0; i < MONTHS.length; ++i) {
            this.comboBox.addItem(MONTHS[i]);
        }
        this.comboBox.addItemListener(this);
        this.add((Component)this.comboBox, "Center");
        if (spinner != 2) {
            this.scrollBar = new JScrollBar(1, 12 - month, 0, -10000, 10000);
            this.scrollBar.setPreferredSize(new Dimension(this.scrollBar.getPreferredSize().width, this.getPreferredSize().height));
            this.scrollBar.setVisibleAmount(0);
            if (spinner == 0) {
                this.add((Component)this.scrollBar, "East");
            } else {
                this.add((Component)this.scrollBar, "West");
            }
            this.scrollBar.addAdjustmentListener(this);
        }
        this.setMonth(month, true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemevent) {
        int index = this.comboBox.getSelectedIndex();
        if (index >= 0) {
            this.setMonth(index, false);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentevent) {
        boolean flag = true;
        int newBarValue = adjustmentevent.getValue();
        if (newBarValue > this.oldBarValue) {
            flag = false;
        }
        this.oldBarValue = newBarValue;
        int j = this.getMonth();
        if (flag) {
            if (++j == 12) {
                j = 0;
                if (this.yearChooser != null) {
                    this.yearChooser.setYear(this.yearChooser.getYear() + 1);
                }
            }
        } else if (--j == -1) {
            j = 11;
            if (this.yearChooser != null) {
                this.yearChooser.setYear(this.yearChooser.getYear() - 1);
            }
        }
        this.setMonth(j);
    }

    private void setMonth(int month, boolean bCombo) {
        int j = this.month;
        this.month = month < 0 ? 0 : (month > 11 ? 11 : month);
        if (bCombo) {
            this.comboBox.setSelectedIndex(this.month);
        }
        if (this.dayChooser != null) {
            this.dayChooser.setMonth(this.month);
        }
        this.firePropertyChange("month", j, this.month);
    }

    public void setMonth(int i) {
        this.setMonth(i, true);
    }

    public int getMonth() {
        return this.month;
    }

    public void setDayChooser(JDayChooser jdaychooser) {
        this.dayChooser = jdaychooser;
    }

    public void setYearChooser(JYearChooser jyearchooser) {
        this.yearChooser = jyearchooser;
    }

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.comboBox.setEnabled(flag);
        if (this.scrollBar != null) {
            this.scrollBar.setEnabled(flag);
        }
    }
}

