/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.utils.calendar;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

class JDayChooser
extends JPanel
implements ActionListener,
KeyListener,
FocusListener {
    private JButton[] days = new JButton[49];
    private JButton selectedDay = null;
    private static final DateFormatSymbols dfSymb = new DateFormatSymbols();
    private static final String[] DAYS = dfSymb.getShortWeekdays();
    private int day;
    private Calendar today = Calendar.getInstance(Locale.getDefault());
    private Calendar calendar = (Calendar)this.today.clone();
    private static Color oldDayBackgroundColor;
    private static final Color RED_COLOR;
    private static final Color BLUE_COLOR;
    private static final Color TODAY_COLOR;
    private static final Color HEADER_COLOR;
    private static final Color SELECTED_COLOR;

    public JDayChooser() {
        this(Calendar.getInstance(Locale.getDefault()).get(5));
    }

    public JDayChooser(int iDay) {
        this.setLayout(new GridLayout(7, 7));
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                int k = j + 7 * i;
                if (i == 0) {
                    this.days[k] = new JButton(){

                        @Override
                        public void addMouseListener(MouseListener mouselistener) {
                        }

                        @Override
                        public boolean isFocusable() {
                            return false;
                        }
                    };
                    this.days[k].setBackground(HEADER_COLOR);
                } else {
                    this.days[k] = new JButton("x");
                    this.days[k].addActionListener(this);
                    this.days[k].addKeyListener(this);
                    this.days[k].addFocusListener(this);
                }
                this.days[k].setMargin(new Insets(0, 0, 0, 0));
                this.days[k].setFocusPainted(false);
                this.days[k].setBorder(BorderFactory.createEtchedBorder());
                this.add(this.days[k]);
            }
        }
        this.init();
        this.setDay(iDay);
    }

    protected void init() {
        JButton jbutton = new JButton();
        oldDayBackgroundColor = jbutton.getBackground();
        for (int i = 0; i < 7; ++i) {
            this.days[i].setText(DAYS[i + 1]);
            if (i + 1 == 1 || i + 1 == 7) {
                this.days[i].setForeground(RED_COLOR);
                continue;
            }
            this.days[i].setForeground(BLUE_COLOR);
        }
        this.drawDays();
    }

    protected void drawDays() {
        Calendar cDate = (Calendar)this.calendar.clone();
        cDate.set(5, 1);
        int dayOfWeek = cDate.get(7);
        int i = 7;
        int m = 1;
        while (m < dayOfWeek) {
            this.days[i].setVisible(false);
            this.days[i].setText("");
            ++m;
            ++i;
        }
        Color color = this.getForeground();
        int curMonth = cDate.get(2);
        int j = 0;
        while (curMonth == cDate.get(2)) {
            this.days[i + j].setText(Integer.toString(j + 1));
            this.days[i + j].setVisible(true);
            if (cDate.get(6) == this.today.get(6) && cDate.get(1) == this.today.get(1)) {
                this.days[i + j].setForeground(TODAY_COLOR);
            } else {
                this.days[i + j].setForeground(color);
            }
            if (j + 1 == this.day) {
                this.days[i + j].setBackground(SELECTED_COLOR);
                this.selectedDay = this.days[i + j];
            } else {
                this.days[i + j].setBackground(oldDayBackgroundColor);
            }
            ++j;
            cDate.add(5, 1);
        }
        for (int k = i + j; k < 49; ++k) {
            this.days[k].setVisible(false);
            this.days[k].setText("");
        }
    }

    public void setDay(int iDay) {
        if (iDay < 1) {
            iDay = 1;
        }
        Calendar cDate = (Calendar)this.calendar.clone();
        cDate.set(5, 1);
        cDate.add(2, 1);
        cDate.add(5, -1);
        int lastDay = cDate.get(5);
        if (iDay > lastDay) {
            iDay = lastDay;
        }
        int k = this.day;
        this.day = iDay;
        if (this.selectedDay != null) {
            this.selectedDay.setBackground(oldDayBackgroundColor);
            this.selectedDay.repaint();
        }
        for (int i = 7; i < 49; ++i) {
            if (!this.days[i].getText().equals(Integer.toString(this.day))) continue;
            this.selectedDay = this.days[i];
            this.selectedDay.setBackground(SELECTED_COLOR);
            break;
        }
        this.firePropertyChange("day", k, this.day);
    }

    public int getDay() {
        return this.day;
    }

    public void setMonth(int month) {
        this.calendar.set(2, month);
        this.setDay(this.day);
        this.drawDays();
    }

    public void setYear(int year) {
        this.calendar.set(1, year);
        this.drawDays();
    }

    public void setCalendar(Calendar cDate) {
        this.calendar = cDate;
        this.drawDays();
    }

    @Override
    public void setFont(Font font) {
        if (this.days != null) {
            for (int i = 0; i < 49; ++i) {
                this.days[i].setFont(font);
            }
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.days != null) {
            for (int i = 7; i < 49; ++i) {
                this.days[i].setForeground(color);
            }
            this.drawDays();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionevent) {
        JButton jbutton = (JButton)actionevent.getSource();
        String s = jbutton.getText();
        int i = new Integer(s);
        this.setDay(i);
    }

    @Override
    public void focusGained(FocusEvent focusevent) {
        JButton jbutton = (JButton)focusevent.getSource();
        String s = jbutton.getText();
        if (s != null && !s.equals("")) {
            this.actionPerformed(new ActionEvent(focusevent.getSource(), 0, null));
        }
    }

    @Override
    public void focusLost(FocusEvent focusevent) {
    }

    @Override
    public void keyPressed(KeyEvent keyevent) {
        int byte0;
        int n = keyevent.getKeyCode() != 38 ? (keyevent.getKeyCode() != 40 ? (keyevent.getKeyCode() != 37 ? (keyevent.getKeyCode() != 39 ? 0 : 1) : -1) : 7) : (byte0 = -7);
        if (byte0 != 0) {
            for (int i = this.getComponentCount() - 1; i >= 0; --i) {
                if (this.getComponent(i) != this.selectedDay) continue;
                if ((i += byte0) <= 7 || i >= this.days.length || !this.days[i].isVisible()) break;
                this.days[i].requestFocus();
                break;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyevent) {
    }

    @Override
    public void keyReleased(KeyEvent keyevent) {
    }

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        for (int s = 0; s < this.days.length; s = (int)((short)(s + 1))) {
            if (this.days[s] == null) continue;
            this.days[s].setEnabled(flag);
        }
    }

    static {
        RED_COLOR = new Color(164, 0, 0);
        BLUE_COLOR = new Color(0, 0, 164);
        TODAY_COLOR = new Color(164, 0, 0);
        HEADER_COLOR = new Color(180, 180, 200);
        SELECTED_COLOR = new Color(160, 160, 160);
    }
}

