/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.services;

import ch.dia.dao.DaoProfil;
import ch.dia.dao.DaoUtilisateur;
import ch.dia.dao.TxScope;
import ch.dia.model.DiaMedecin;
import ch.dia.model.DiaProfil;
import ch.dia.model.DiaUtilisateur;
import ch.dia.services.AbstractService;
import ch.dia.services.MailServices;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class SrvProfil
extends AbstractService {
    private final DaoUtilisateur utilisateurOm;
    private final DaoProfil profilOm;
    private final MailServices mailServices;

    public SrvProfil(DaoUtilisateur utilisateurOm, DaoProfil profilOm) {
        this.utilisateurOm = utilisateurOm;
        this.profilOm = profilOm;
        this.mailServices = new MailServices();
    }

    public List<DiaProfil> getProfil(DiaUtilisateur pUser, String sId) {
        List<DiaProfil> userProfils = Collections.emptyList();
        if (sId != null && !sId.equals("0") && sId.trim().length() > 1) {
            int idPatient = this.utilisateurOm.getUtilisateurByMail(sId).getId();
            if (pUser instanceof DiaMedecin) {
                userProfils = this.profilOm.getUserProfil(idPatient);
            }
        } else if (!(pUser instanceof DiaMedecin)) {
            userProfils = this.profilOm.getUserProfil(pUser.getId());
        }
        return userProfils;
    }

    public DiaUtilisateur setProfil(final DiaUtilisateur pUser, final String sMail, final DiaProfil pProfil) {
        return this.doInTx(this.utilisateurOm, new TxScope<DiaUtilisateur>(){

            @Override
            public DiaUtilisateur run() {
                DiaUtilisateur pPatient = null;
                if (sMail != null && sMail.trim().length() > 1) {
                    if (pUser instanceof DiaMedecin) {
                        pPatient = SrvProfil.this.utilisateurOm.getUtilisateurByMail(sMail);
                        pProfil.setIdUti(pPatient.getId());
                        SrvProfil.this.profilOm.saveEntityProfil(pProfil);
                    }
                } else {
                    pProfil.setIdUti(pUser.getId());
                    SrvProfil.this.profilOm.saveEntityProfil(pProfil);
                }
                return pPatient;
            }
        });
    }

    public void updateProfil(String sMail, DiaProfil pProfil, DiaUtilisateur pUser, Locale locale) {
        DiaUtilisateur pPatient = this.setProfil(pUser, sMail, pProfil);
        if (pPatient != null && pPatient.getId() > 0 && pUser instanceof DiaMedecin) {
            this.mailServices.sendModifiedProfiltFromDoctor(pProfil, pUser, pPatient, locale);
        } else {
            this.mailServices.sendMailProfilTo(pProfil, pUser, locale);
        }
    }
}

