/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.services;

import ch.dia.dao.DaoAccesUtilisateur;
import ch.dia.dao.DaoUtilisateur;
import ch.dia.dao.TxScope;
import ch.dia.model.DiaAccesutilisateur;
import ch.dia.model.DiaAdministrateur;
import ch.dia.model.DiaMedecin;
import ch.dia.model.DiaUtilisateur;
import ch.dia.services.AbstractService;
import ch.dia.utils.utString;
import java.util.ArrayList;
import java.util.List;

public class SrvMedecinPatient
extends AbstractService {
    private final DaoUtilisateur utilisateurOm;
    private final DaoAccesUtilisateur accesUtilisateurOm;

    public SrvMedecinPatient(DaoUtilisateur utilisateurOm, DaoAccesUtilisateur accesUtilisateurOm) {
        this.utilisateurOm = utilisateurOm;
        this.accesUtilisateurOm = accesUtilisateurOm;
    }

    public List<DiaUtilisateur> listMedecinsPatient(DiaUtilisateur pUser, boolean choix, boolean all) {
        List<DiaUtilisateur> lst = new ArrayList<DiaUtilisateur>();
        if (choix) {
            if (all) {
                if (!(pUser instanceof DiaMedecin)) {
                    lst = this.utilisateurOm.getMedecinVisible();
                }
            } else if (!(pUser instanceof DiaMedecin)) {
                lst = this.accesUtilisateurOm.listMedecinsByPatientId(pUser.getId());
            }
        } else if (pUser instanceof DiaMedecin) {
            lst = this.accesUtilisateurOm.listPatientsByUserId(pUser.getId());
        } else if (pUser instanceof DiaAdministrateur) {
            lst = this.utilisateurOm.getPatient();
        }
        return lst;
    }

    public void setMedecinPatient(DiaUtilisateur pUser, String lstChoix) {
        String[] medecins;
        final ArrayList<String> lstMedecin = new ArrayList<String>();
        for (String medecin : medecins = lstChoix.split(",")) {
            lstMedecin.add(utString.stringNotNull(medecin));
        }
        final int idPatient = pUser.getId();
        this.doInTx(this.accesUtilisateurOm, new TxScope<Boolean>(){

            @Override
            public Boolean run() {
                for (String mailMedecin : lstMedecin) {
                    DiaUtilisateur pMedecin = SrvMedecinPatient.this.utilisateurOm.getUtilisateurByMail(mailMedecin);
                    DiaAccesutilisateur pDiaAccesutilisateur = new DiaAccesutilisateur();
                    pDiaAccesutilisateur.setIdPatient(idPatient);
                    pDiaAccesutilisateur.setIdUti(pMedecin.getId());
                    if (!SrvMedecinPatient.this.accesUtilisateurOm.getListPatientMedecin(idPatient, pMedecin.getId()).isEmpty()) continue;
                    SrvMedecinPatient.this.accesUtilisateurOm.saveEntity(pDiaAccesutilisateur);
                }
                return true;
            }
        });
    }

    public void removeMedecinPatient(DiaUtilisateur pUser, boolean bPatient, String patient, String medecin) {
        int idPatient = 0;
        int idMedecin = 0;
        if (bPatient) {
            if (!(pUser instanceof DiaMedecin)) {
                idMedecin = this.utilisateurOm.getUtilisateurByMail(medecin).getId();
                idPatient = pUser.getId();
            }
        } else if (pUser instanceof DiaMedecin) {
            idPatient = this.utilisateurOm.getUtilisateurByMail(patient).getId();
            idMedecin = pUser.getId();
        }
        this.removeAcces(idPatient, idMedecin);
    }

    private Boolean removeAcces(final int idPatient, final int idMedecin) {
        return this.doInTx(this.accesUtilisateurOm, new TxScope<Boolean>(){

            @Override
            public Boolean run() {
                SrvMedecinPatient.this.accesUtilisateurOm.removeList(SrvMedecinPatient.this.accesUtilisateurOm.getListPatientMedecin(idPatient, idMedecin));
                return true;
            }
        });
    }
}

