/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.services;

import ch.dia.dao.DaoAccesUtilisateur;
import ch.dia.dao.DaoUtilisateur;
import ch.dia.dao.TxScope;
import ch.dia.model.DiaAccesutilisateur;
import ch.dia.model.DiaMedecin;
import ch.dia.model.DiaPatient;
import ch.dia.model.DiaUtilisateur;
import ch.dia.services.AbstractService;
import ch.dia.services.MailServices;
import ch.dia.utils.PasswordUtils;
import ch.dia.utils.utSha1;
import ch.dia.utils.utString;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.StringEscapeUtils;

public class SrvInscription
extends AbstractService {
    private final DaoUtilisateur utilisateurOm;
    private final DaoAccesUtilisateur accesUtilisateurOm;
    MailServices mailServices;
    private String password;

    public SrvInscription(DaoUtilisateur utilisateurOm, DaoAccesUtilisateur accesUtilisateurOm) {
        this.utilisateurOm = utilisateurOm;
        this.accesUtilisateurOm = accesUtilisateurOm;
        this.mailServices = new MailServices();
    }

    public DiaUtilisateur getUtilisateurByMail(String mail) {
        return this.utilisateurOm.findUserByEmail(mail);
    }

    private DiaUtilisateur addPatient(DiaUtilisateur pUser, String password, Integer sexe, String nom, String prenom, String email) {
        DiaUtilisateur pNewUser = null;
        if (pUser instanceof DiaMedecin) {
            DiaMedecin medecin = (DiaMedecin)pUser;
            pNewUser = this.utilisateurOm.findUserByEmail(email);
            if (pNewUser != null && pNewUser.getId() > 0) {
                if (!this.accesUtilisateurOm.getIfPatientMedecin(pNewUser.getId(), medecin.getId())) {
                    DiaAccesutilisateur pAccUser = new DiaAccesutilisateur(medecin.getId(), pNewUser.getId());
                    this.accesUtilisateurOm.saveEntity(pAccUser);
                }
            } else {
                pNewUser = new DiaPatient(sexe, nom, prenom, email, password);
                this.utilisateurOm.saveEntity(pNewUser);
                if (pNewUser.getId() > 0) {
                    String sha1 = pNewUser.getId().toString() + pNewUser.getEmail();
                    pNewUser.setIdSha(utSha1.SHA1(sha1));
                    this.utilisateurOm.saveEntity(pNewUser);
                }
            }
        }
        return pNewUser;
    }

    public void addPatientToUser(final DiaUtilisateur pUser, final DiaUtilisateur patient, final Locale locale) {
        this.doInTx(this.accesUtilisateurOm, new TxScope<Boolean>(){

            @Override
            public Boolean run() {
                boolean bNewUser = true;
                DiaUtilisateur pNewUser = SrvInscription.this.getUtilisateurByMail(patient.getEmail());
                if (pNewUser != null && pNewUser.getId() > 0) {
                    bNewUser = false;
                }
                String password = PasswordUtils.generatePassword();
                String passwordBdd = utSha1.SHA1(password + patient.getEmail());
                pNewUser = SrvInscription.this.addPatient(pUser, passwordBdd, patient.getSexe(), patient.getNom(), patient.getPrenom(), patient.getEmail());
                SrvInscription.this.mailServices.sendIncriptionEmailWithCopyTo(pUser, locale, bNewUser, password, pNewUser);
                return true;
            }
        });
    }

    public DiaUtilisateur createNewPatient(final int sexe, final String nom, final String prenom, final String mail, final String password, final Locale locale) {
        return this.doInTx(this.utilisateurOm, new TxScope<DiaUtilisateur>(){

            @Override
            public DiaUtilisateur run() {
                DiaPatient user = (DiaPatient)SrvInscription.this.fillUser(new DiaPatient(mail.toLowerCase()), sexe, nom, prenom, password);
                SrvInscription.this.mailServices.sendIncriptionEmail(user, locale);
                return SrvInscription.this.utilisateurOm.saveEntity(user);
            }
        });
    }

    public DiaUtilisateur createNewMedecin(final int sexe, final String nom, final String prenom, final String mail, final String password, final String adresse, final String mc, final String mp, final String mt, final String mville, final String mv, final Locale locale) {
        return this.doInTx(this.utilisateurOm, new TxScope<DiaUtilisateur>(){

            @Override
            public DiaUtilisateur run() {
                DiaMedecin medecin = new DiaMedecin(mail.toLowerCase());
                SrvInscription.this.fillUser(medecin, sexe, nom, prenom, password);
                SrvInscription.this.fillMedecin(medecin, adresse, mc, mp, mt, mville, mv);
                SrvInscription.this.mailServices.sendIncriptionEmail(medecin, locale);
                return SrvInscription.this.utilisateurOm.saveEntity(medecin);
            }
        });
    }

    private <T extends DiaUtilisateur> T fillUser(T user, int sexe, String nom, String prenom, String password) {
        user.setSexe(sexe);
        user.setNom(utString.stringNotNull(StringEscapeUtils.escapeJava((String)nom)));
        user.setPrenom(utString.stringNotNull(StringEscapeUtils.escapeJava((String)prenom)));
        user.setMotpasse(utSha1.SHA1(password + user.getEmail()));
        user.setDtCreation(new Date());
        user.setActif(1);
        return user;
    }

    private DiaMedecin fillMedecin(DiaMedecin medecin, String ma, String mc, String pays, String tel, String ville, String shouldBeVisible) {
        medecin.setAdresse(utString.stringNotNull(StringEscapeUtils.escapeJava((String)ma)));
        medecin.setCp(utString.stringNotNull(StringEscapeUtils.escapeJava((String)mc)));
        medecin.setPays(utString.stringNotNull(StringEscapeUtils.escapeJava((String)pays)));
        medecin.setTel(utString.stringNotNull(StringEscapeUtils.escapeJava((String)tel)));
        medecin.setVille(utString.stringNotNull(StringEscapeUtils.escapeJava((String)ville)));
        medecin.setVisible(utString.stringNotNull(shouldBeVisible));
        return medecin;
    }

    public DiaUtilisateur setNewPassword(final String mail, final Locale locale) {
        return this.doInTx(this.utilisateurOm, new TxScope<DiaUtilisateur>(){

            @Override
            public DiaUtilisateur run() {
                SrvInscription.this.password = PasswordUtils.generatePassword();
                DiaUtilisateur user = SrvInscription.this.utilisateurOm.findUserByEmail(mail.toLowerCase());
                user.setMotpasse(utSha1.SHA1(SrvInscription.this.password + mail));
                SrvInscription.this.utilisateurOm.saveEntity(user);
                SrvInscription.this.mailServices.sendPasswordRegenerated(user, SrvInscription.this.password, locale);
                return user;
            }
        });
    }

    public void generateNewPassord(String mail, Locale locale) {
        DiaUtilisateur user = this.setNewPassword(mail, locale);
        if (user != null && user.getId() > 0) {
            this.mailServices.sendPasswordRegenerated(user, this.password, locale);
        }
    }
}

