/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.services;

import ch.dia.dao.DaoAccesUtilisateur;
import ch.dia.dao.DaoDonnees;
import ch.dia.dao.DaoUtilisateur;
import ch.dia.dao.TxScope;
import ch.dia.exceptions.NoAccessForUserException;
import ch.dia.exceptions.NoEntityFoundException;
import ch.dia.model.DiaDonnees;
import ch.dia.model.DiaUtilisateur;
import ch.dia.model.TypeHoraire;
import ch.dia.services.AbstractService;
import ch.dia.services.MailServices;
import ch.dia.utils.utDate;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class SrvInjection
extends AbstractService {
    private final MailServices mailServices;
    DaoAccesUtilisateur daoAccesUtilisateur;
    DaoDonnees donneesOm;
    DaoUtilisateur utilisateurOm;

    public SrvInjection(DaoDonnees donneesOm, DaoUtilisateur utilisateurOm, DaoAccesUtilisateur daoAccesUtilisateur) {
        this.donneesOm = donneesOm;
        this.utilisateurOm = utilisateurOm;
        this.daoAccesUtilisateur = daoAccesUtilisateur;
        this.mailServices = new MailServices();
    }

    public List<DiaDonnees> getInjection(DiaUtilisateur pUser, TypeHoraire horaire, String dtDebut, String dtFin, int glycemieAuto) {
        return this.donneesOm.getUserData(pUser.getId(), horaire, dtDebut, dtFin, glycemieAuto);
    }

    private int getIdUser(DiaUtilisateur pUser, String sMail) {
        DiaUtilisateur utilisateur;
        int idUser = pUser.getId();
        if (sMail != null && sMail.trim().length() > 1 && (utilisateur = this.utilisateurOm.getUtilisateurByMail(sMail)) != null) {
            idUser = utilisateur.getId();
        }
        return idUser;
    }

    List<DiaDonnees> getLastMonthUserData(DiaUtilisateur user) {
        return this.getInjection(user, TypeHoraire.u0, utDate.convertToStringMySql(utDate.getCurrentDateMoinsOneMonth()), utDate.convertToStringMySql(utDate.getCurrentDate()), 0);
    }

    List<DiaDonnees> getNextMonthUserData(DiaUtilisateur user) {
        return this.getInjection(user, TypeHoraire.u0, utDate.convertToStringMySql(utDate.getCurrentDate()), utDate.convertToStringMySql(utDate.getCurrentDatePlusOneMonth()), 0);
    }

    public List<DiaDonnees> listUserInjection(DiaUtilisateur pUser, boolean isVersionMobile, String sMail, Boolean last, int glycemieAuto, TypeHoraire sHoraire, String sDebut, String sFin) {
        int idUser = this.getIdUser(pUser, sMail);
        if (idUser > 0) {
            if (Boolean.TRUE.equals(last) || isVersionMobile) {
                return this.donneesOm.getLastUserData(idUser);
            }
            if (sFin.length() > 0) {
                return this.donneesOm.getUserData(idUser, sHoraire, sDebut, sFin, glycemieAuto);
            }
            return this.donneesOm.getUserData(idUser, sHoraire, sDebut, glycemieAuto);
        }
        return Collections.emptyList();
    }

    public DiaDonnees getSingleInjection(DiaUtilisateur user, int idData) {
        return this.donneesOm.getData(idData);
    }

    private void checkUserAccess(DiaUtilisateur pUser, String sId) throws NoAccessForUserException {
        int countAccess;
        if (sId != null && (countAccess = this.daoAccesUtilisateur.listAccessForPatient(pUser.getId(), sId).intValue()) == 0) {
            throw new NoAccessForUserException("User <" + pUser.getId() + "> doesn't have access to user <" + sId + ">");
        }
    }

    public void saveUserDonnees(final DiaUtilisateur pUser, final DiaDonnees[] pData) {
        this.doInTx(this.donneesOm, new TxScope<Boolean>(){

            @Override
            public Boolean run() {
                for (DiaDonnees data : pData) {
                    data.setUtilisateur(pUser);
                    if (data.getRepas() == null) {
                        data.setRepas(0);
                    }
                    if (data.getGlycemieAuto() == null) {
                        data.setGlycemieAuto(0);
                    }
                    if (data.getGlycemieCapteur() == null) {
                        data.setGlycemieCapteur(0);
                    }
                    SrvInjection.this.donneesOm.saveDonnees(data);
                }
                return true;
            }
        });
    }

    public void removeInjection(DiaUtilisateur pUser, int idData) throws NoAccessForUserException, NoEntityFoundException {
        final DiaDonnees pData = this.donneesOm.getData(idData);
        if (pData == null) {
            throw new NoEntityFoundException("DiaDonnees ID <" + idData + "> is not found");
        }
        if (!pUser.equals(pData.getUtilisateur())) {
            throw new NoAccessForUserException("Trying to remove a data which doesn't belong to the connected user");
        }
        this.doInTx(this.donneesOm, new TxScope<Boolean>(){

            @Override
            public Boolean run() {
                SrvInjection.this.donneesOm.removeEntity(pData);
                return true;
            }
        });
    }

    public void saveGlycemies(String email, DiaUtilisateur user, Locale locale) {
        this.mailServices.sendMailWithFile(user, email, locale, this.getLastMonthUserData(user));
    }
}

