/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.services;

import ch.dia.dao.DaoAccesUtilisateur;
import ch.dia.dao.DaoUtilisateur;
import ch.dia.dao.TxScope;
import ch.dia.model.DiaMedecin;
import ch.dia.model.DiaUtilisateur;
import ch.dia.services.AbstractService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SrvInformation
extends AbstractService {
    private final DaoUtilisateur utilisateurOm;
    private final DaoAccesUtilisateur accesUtilisateurOm;

    public SrvInformation(DaoUtilisateur utilisateurOm, DaoAccesUtilisateur accesUtilisateurOm) {
        this.utilisateurOm = utilisateurOm;
        this.accesUtilisateurOm = accesUtilisateurOm;
    }

    public List<DiaUtilisateur> getInformations(String idSha) {
        return Collections.singletonList(this.utilisateurOm.getIdShaUtilisateur(idSha));
    }

    public List<DiaUtilisateur> getInformationsByMail(int idMedecin, String mail) {
        List<DiaUtilisateur> lstReturn = new ArrayList<DiaUtilisateur>();
        List<DiaUtilisateur> lstPatient = this.accesUtilisateurOm.listPatientsByUserId(idMedecin);
        DiaUtilisateur patient = this.utilisateurOm.getUtilisateurByMail(mail);
        for (DiaUtilisateur p : lstPatient) {
            if (p == null || patient.getId() != p.getId()) continue;
            lstReturn = Collections.singletonList(patient);
        }
        return lstReturn;
    }

    public DiaUtilisateur saveInformations(final DiaUtilisateur pUser, final int sexe, final String nom, final String prenom, final String mail, final String ma, final String mc, final String mp, final String mt, final String mville, final String mv) {
        return this.doInTx(this.utilisateurOm, new TxScope<DiaUtilisateur>(){

            @Override
            public DiaUtilisateur run() {
                pUser.setSexe(sexe);
                pUser.setNom(nom);
                pUser.setPrenom(prenom);
                pUser.setEmail(mail);
                if (pUser instanceof DiaMedecin) {
                    DiaMedecin pMedecin = (DiaMedecin)pUser;
                    pMedecin.setAdresse(ma);
                    pMedecin.setTel(mt);
                    pMedecin.setCp(mc);
                    pMedecin.setVille(mville);
                    pMedecin.setPays(mp);
                    pMedecin.setVisible(mv);
                }
                return SrvInformation.this.utilisateurOm.saveEntity(pUser);
            }
        });
    }
}

