/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.services;

import ch.dia.dao.DaoDonnees;
import ch.dia.dao.TxScope;
import ch.dia.model.DiaDonnees;
import ch.dia.model.DiaUtilisateur;
import ch.dia.services.AbstractService;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class SrvImport
extends AbstractService {
    private DaoDonnees donneesOm;

    public SrvImport(DaoDonnees donneesOm) {
        this.donneesOm = donneesOm;
    }

    public int importData(DiaUtilisateur user, InputStream is, boolean freeStyle) {
        int nbDataTransfert = 0;
        if (freeStyle) {
            nbDataTransfert = this.importDataFreeStyle(user, is);
        }
        return nbDataTransfert;
    }

    public int importDataFreeStyle(DiaUtilisateur user, InputStream is) {
        int line = 0;
        int type = 0;
        String str = "";
        float glycemie = 0.0f;
        ArrayList<DiaDonnees> pAllData = new ArrayList<DiaDonnees>();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            if (is != null) {
                while ((str = reader.readLine()) != null) {
                    if (++line < 3 || str.length() <= 10) continue;
                    String[] data = str.split("\\t");
                    DiaDonnees pData = new DiaDonnees();
                    data[1] = data[1].replace("/", "-");
                    pData.setDateInj(data[1].substring(0, 10));
                    pData.setTimeInj(data[1].substring(11) + ":00");
                    type = Integer.parseInt(data[2]);
                    if (type != 0 && type != 1) continue;
                    if (type == 0) {
                        data[3] = data[3].replace(",", ".");
                        glycemie = Float.parseFloat(data[3]);
                    } else if (type == 1) {
                        data[4] = data[4].replace(",", ".");
                        glycemie = Float.parseFloat(data[4]);
                    }
                    pData.setGlycemieCapteur(1);
                    pData.setGlycemie(Float.valueOf(glycemie));
                    pData.setCommentaire("");
                    pAllData.add(pData);
                }
                is.close();
                this.setDataFreeStyle(user, pAllData);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception during Import", ex);
        }
        return pAllData.size();
    }

    public void setDataFreeStyle(final DiaUtilisateur pUser, final List<DiaDonnees> pData) {
        this.doInTx(this.donneesOm, new TxScope<Boolean>(){

            @Override
            public Boolean run() {
                float zero = 0.0f;
                for (DiaDonnees data : pData) {
                    data.setUtilisateur(pUser);
                    if (data.getNbHdc() == null) {
                        data.setNbHdc(Float.valueOf(zero));
                    }
                    if (data.getInjection() == null) {
                        data.setInjection(Float.valueOf(zero));
                    }
                    if (data.getRepas() == null) {
                        data.setRepas(0);
                    }
                    if (data.getGlycemieAuto() != null) continue;
                    data.setGlycemieAuto(0);
                }
                if (SrvImport.this.donneesOm.removeDataCapteur(pUser.getId()) >= 0) {
                    SrvImport.this.donneesOm.saveDataCapteur(pData);
                }
                return true;
            }
        });
    }
}

