/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.services;

import ch.dia.dao.DaoRepas;
import ch.dia.dao.TxScope;
import ch.dia.model.DiaComposition;
import ch.dia.model.DiaRepas;
import ch.dia.model.DiaUtilisateur;
import ch.dia.services.AbstractService;
import java.util.List;

public class SrvFavoris
extends AbstractService {
    private final DaoRepas repasOm;

    public SrvFavoris(DaoRepas repasOm) {
        this.repasOm = repasOm;
    }

    public List<DiaRepas> getUserRepas(DiaUtilisateur pUser) {
        return this.repasOm.getMesRepas(pUser.getId());
    }

    public void saveUserRepas(final DiaUtilisateur pUser, final List<DiaRepas> lstRepas) {
        this.doInTx(this.repasOm, new TxScope<Boolean>(){

            @Override
            public Boolean run() {
                for (DiaRepas repas : lstRepas) {
                    repas.setIdUti(pUser.getId());
                    List<DiaComposition> compositions = repas.getCompositions();
                    if (compositions != null) {
                        for (DiaComposition comp : compositions) {
                            comp.setRepas(repas);
                        }
                    }
                    SrvFavoris.this.repasOm.saveEntity(repas);
                }
                return true;
            }
        });
    }

    public void saveUserRepas(final DiaUtilisateur pUser, final DiaRepas[] pRepas) {
        this.doInTx(this.repasOm, new TxScope<Boolean>(){

            @Override
            public Boolean run() {
                for (DiaRepas repas : pRepas) {
                    repas.setIdUti(pUser.getId());
                    List<DiaComposition> compositions = repas.getCompositions();
                    if (compositions != null) {
                        for (DiaComposition comp : compositions) {
                            comp.setRepas(repas);
                        }
                    }
                    SrvFavoris.this.repasOm.saveEntity(repas);
                }
                return true;
            }
        });
    }

    public void deleteFavoris(final DiaUtilisateur pUser, final int idFavoris) {
        this.doInTx(this.repasOm, new TxScope<Boolean>(){

            @Override
            public Boolean run() {
                DiaRepas repas = SrvFavoris.this.repasOm.getRepas(idFavoris);
                if (pUser.getId().equals(repas.getIdUti())) {
                    SrvFavoris.this.repasOm.removeEntity(repas);
                }
                return true;
            }
        });
    }
}

